import _Object$getPrototypeOf from 'babel-runtime/core-js/object/get-prototype-of';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import { startsWith } from '../utils/lang';
import KeyBuilder from './Keys';
import { matching } from '../utils/key/factory';

var KeyBuilderForLocalStorage = function (_KeyBuilder) {
  _inherits(KeyBuilderForLocalStorage, _KeyBuilder);

  function KeyBuilderForLocalStorage() {
    _classCallCheck(this, KeyBuilderForLocalStorage);

    return _possibleConstructorReturn(this, (KeyBuilderForLocalStorage.__proto__ || _Object$getPrototypeOf(KeyBuilderForLocalStorage)).apply(this, arguments));
  }

  _createClass(KeyBuilderForLocalStorage, [{
    key: 'buildSegmentNameKey',
    value: function buildSegmentNameKey(segmentName) {
      return matching(this.settings.core.key) + '.' + this.settings.storage.prefix + '.segment.' + segmentName;
    }
  }, {
    key: 'extractSegmentName',
    value: function extractSegmentName(builtSegmentKeyName) {
      var prefix = matching(this.settings.core.key) + '.' + this.settings.storage.prefix + '.segment.';

      if (startsWith(builtSegmentKeyName, prefix)) return builtSegmentKeyName.substr(prefix.length);
    }
  }, {
    key: 'buildSplitsWithSegmentCountKey',
    value: function buildSplitsWithSegmentCountKey() {
      return this.settings.storage.prefix + '.splits.usingSegments';
    }
  }]);

  return KeyBuilderForLocalStorage;
}(KeyBuilder);

export default KeyBuilderForLocalStorage;