import _Object$getPrototypeOf from 'babel-runtime/core-js/object/get-prototype-of';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
import findIndex from './findIndex';
import BaseMetricsAsyncCache from '../BaseMetricsAsyncCache';

var LatencyCacheInRedis = function (_BaseMetricsAsyncCach) {
  _inherits(LatencyCacheInRedis, _BaseMetricsAsyncCach);

  function LatencyCacheInRedis(keys, redis) {
    _classCallCheck(this, LatencyCacheInRedis);

    var _this = _possibleConstructorReturn(this, (LatencyCacheInRedis.__proto__ || _Object$getPrototypeOf(LatencyCacheInRedis)).call(this));

    _this.keys = keys;
    _this.redis = redis;
    return _this;
  }

  _createClass(LatencyCacheInRedis, [{
    key: 'track',
    value: function track(metricName, latency) {
      var bucketNumber = findIndex(latency);

      return this.redis.incr(this.keys.buildLatencyKey(metricName, bucketNumber)).catch(function () {
        // noop, for telemetry metrics there's no need to throw.
      });
    }
  }]);

  return LatencyCacheInRedis;
}(BaseMetricsAsyncCache);

export default LatencyCacheInRedis;