import _Object$keys from 'babel-runtime/core-js/object/keys';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import logFactory from '../../../utils/logger';
var log = logFactory('splitio-storage:localstorage');

var DEFINED = '1';

var SegmentCacheInLocalStorage = function () {
  function SegmentCacheInLocalStorage(keys) {
    _classCallCheck(this, SegmentCacheInLocalStorage);

    this.keys = keys;
  }

  _createClass(SegmentCacheInLocalStorage, [{
    key: 'addToSegment',
    value: function addToSegment(segmentName /*, segmentKeys: Array<string>*/) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      try {
        localStorage.setItem(segmentKey, DEFINED);
        return true;
      } catch (e) {
        log.error(e);
        return false;
      }
    }
  }, {
    key: 'removeFromSegment',
    value: function removeFromSegment(segmentName /*, segmentKeys: Array<string>*/) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      try {
        localStorage.removeItem(segmentKey);
        return true;
      } catch (e) {
        log.error(e);
        return false;
      }
    }
  }, {
    key: 'resetSegments',
    value: function resetSegments(segmentNames) {
      var _this = this;

      var isDiff = false;
      var index = void 0;

      // Scan current values from localStorage
      var storedSegmentNames = _Object$keys(localStorage).reduce(function (accum, key) {
        var segmentName = _this.keys.extractSegmentName(key);

        if (segmentName) accum.push(segmentName);

        return accum;
      }, []);

      // Extreme fast => everything is empty
      if (segmentNames.length === 0 && storedSegmentNames.length === segmentNames.length) return isDiff;

      // Quick path
      if (storedSegmentNames.length !== segmentNames.length) {
        isDiff = true;

        storedSegmentNames.forEach(function (segmentName) {
          return _this.removeFromSegment(segmentName);
        });
        segmentNames.forEach(function (segmentName) {
          return _this.addToSegment(segmentName);
        });
      } else {
        // Slowest path => we need to find at least 1 difference because
        for (index = 0; index < segmentNames.length && storedSegmentNames.indexOf(segmentNames[index]) !== -1; index++) {
          // TODO: why empty statement?
        }

        if (index < segmentNames.length) {
          isDiff = true;

          storedSegmentNames.forEach(function (segmentName) {
            return _this.removeFromSegment(segmentName);
          });
          segmentNames.forEach(function (segmentName) {
            return _this.addToSegment(segmentName);
          });
        }
      }

      return isDiff;
    }
  }, {
    key: 'isInSegment',
    value: function isInSegment(segmentName /*, key: string*/) {
      return localStorage.getItem(this.keys.buildSegmentNameKey(segmentName)) === DEFINED;
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber() /*segmentName: string, changeNumber: number*/{
      return true;
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber() /*segmentName: string*/{
      return -1;
    }
  }, {
    key: 'registerSegment',
    value: function registerSegment() /*segment: string*/{
      return false;
    }
  }, {
    key: 'registerSegments',
    value: function registerSegments() /*segments: Iterable<string>*/{
      return false;
    }
  }, {
    key: 'getRegisteredSegments',
    value: function getRegisteredSegments() {
      return [];
    }
  }, {
    key: 'flush',
    value: function flush() {
      log.info('Flushing localStorage');
      localStorage.clear();
    }
  }]);

  return SegmentCacheInLocalStorage;
}();

export default SegmentCacheInLocalStorage;