import _getIterator from "babel-runtime/core-js/get-iterator";
import _Map from "babel-runtime/core-js/map";
import _classCallCheck from "babel-runtime/helpers/classCallCheck";
import _createClass from "babel-runtime/helpers/createClass";

var SegmentCacheInMemory = function () {
  function SegmentCacheInMemory(keys) {
    _classCallCheck(this, SegmentCacheInMemory);

    this.keys = keys;
    this.flush();
  }

  _createClass(SegmentCacheInMemory, [{
    key: "flush",
    value: function flush() {
      this.segmentCache = new _Map();
    }
  }, {
    key: "addToSegment",
    value: function addToSegment(segmentName /*, segmentKeys: Array<string>*/) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      this.segmentCache.set(segmentKey, true);

      return true;
    }
  }, {
    key: "removeFromSegment",
    value: function removeFromSegment(segmentName /*, segmentKeys: Array<string>*/) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      this.segmentCache.delete(segmentKey);

      return true;
    }

    // @NOTE based on the way we use segments in the browser, this way is the best
    //       option

  }, {
    key: "resetSegments",
    value: function resetSegments(segmentNames) {
      var isDiff = false;
      var index = void 0;
      var s = void 0;

      // Extreme fast => everything is empty
      if (segmentNames.length === 0 && this.segmentCache.size === segmentNames.length) return isDiff;

      // Quick path
      if (this.segmentCache.size !== segmentNames.length) {
        isDiff = true;

        this.segmentCache = new _Map();
        var _iteratorNormalCompletion = true;
        var _didIteratorError = false;
        var _iteratorError = undefined;

        try {
          for (var _iterator = _getIterator(segmentNames), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
            s = _step.value;

            this.addToSegment(s);
          }
        } catch (err) {
          _didIteratorError = true;
          _iteratorError = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion && _iterator.return) {
              _iterator.return();
            }
          } finally {
            if (_didIteratorError) {
              throw _iteratorError;
            }
          }
        }
      } else {
        // Slowest path => we need to find at least 1 difference because
        for (index = 0; index < segmentNames.length && this.isInSegment(segmentNames[index]); index++) {
          // TODO: why empty statement?
        }

        if (index < segmentNames.length) {
          isDiff = true;

          this.segmentCache = new _Map();
          var _iteratorNormalCompletion2 = true;
          var _didIteratorError2 = false;
          var _iteratorError2 = undefined;

          try {
            for (var _iterator2 = _getIterator(segmentNames), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
              s = _step2.value;

              this.addToSegment(s);
            }
          } catch (err) {
            _didIteratorError2 = true;
            _iteratorError2 = err;
          } finally {
            try {
              if (!_iteratorNormalCompletion2 && _iterator2.return) {
                _iterator2.return();
              }
            } finally {
              if (_didIteratorError2) {
                throw _iteratorError2;
              }
            }
          }
        }
      }

      return isDiff;
    }
  }, {
    key: "isInSegment",
    value: function isInSegment(segmentName /*, key: string*/) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      return this.segmentCache.get(segmentKey) === true;
    }
  }, {
    key: "setChangeNumber",
    value: function setChangeNumber() /*segmentName: string, changeNumber: number*/{
      return true;
    }
  }, {
    key: "getChangeNumber",
    value: function getChangeNumber() /*segmentName: string*/{
      return -1;
    }
  }, {
    key: "registerSegment",
    value: function registerSegment() /*segment: string*/{
      return false;
    }
  }, {
    key: "registerSegments",
    value: function registerSegments() /*segments: Iterable<string>*/{
      return false;
    }
  }, {
    key: "getRegisteredSegments",
    value: function getRegisteredSegments() {
      return [];
    }
  }]);

  return SegmentCacheInMemory;
}();

export default SegmentCacheInMemory;