import _Map from "babel-runtime/core-js/map";
import _Number$isInteger from "babel-runtime/core-js/number/is-integer";
import _getIterator from "babel-runtime/core-js/get-iterator";
import _Set from "babel-runtime/core-js/set";
import _classCallCheck from "babel-runtime/helpers/classCallCheck";
import _createClass from "babel-runtime/helpers/createClass";

var SegmentCacheInMemory = function () {
  function SegmentCacheInMemory(keys) {
    _classCallCheck(this, SegmentCacheInMemory);

    this.keys = keys;
    this.flush();
  }

  _createClass(SegmentCacheInMemory, [{
    key: "addToSegment",
    value: function addToSegment(segmentName, segmentKeys) {
      var values = this.segmentCache.get(segmentName);
      var keySet = values ? values : new _Set();

      segmentKeys.forEach(function (k) {
        return keySet.add(k);
      });

      this.segmentCache.set(segmentName, keySet);

      return true;
    }
  }, {
    key: "removeFromSegment",
    value: function removeFromSegment(segmentName, segmentKeys) {
      var values = this.segmentCache.get(segmentName);
      var keySet = values ? values : new _Set();

      segmentKeys.forEach(function (k) {
        return keySet.delete(k);
      });

      this.segmentCache.set(segmentName, keySet);

      return true;
    }
  }, {
    key: "isInSegment",
    value: function isInSegment(segmentName, key) {
      var segmentValues = this.segmentCache.get(segmentName);

      if (segmentValues) {
        return segmentValues.has(key);
      }

      return false;
    }
  }, {
    key: "registerSegment",
    value: function registerSegment(segmentName) {
      if (!this.segmentCache.has(segmentName)) {
        this.segmentCache.set(segmentName, new _Set());
      }

      return true;
    }
  }, {
    key: "registerSegments",
    value: function registerSegments(segments) {
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = _getIterator(segments), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var segmentName = _step.value;

          this.registerSegment(segmentName);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return true;
    }
  }, {
    key: "getRegisteredSegments",
    value: function getRegisteredSegments() {
      return this.segmentCache.keys();
    }
  }, {
    key: "setChangeNumber",
    value: function setChangeNumber(segmentName, changeNumber) {
      var segmentChangeNumberKey = this.keys.buildSegmentTillKey(segmentName);

      this.segmentChangeNumber.set(segmentChangeNumberKey, changeNumber);

      return true;
    }
  }, {
    key: "getChangeNumber",
    value: function getChangeNumber(segmentName) {
      var segmentChangeNumberKey = this.keys.buildSegmentTillKey(segmentName);
      var value = this.segmentChangeNumber.get(segmentChangeNumberKey);

      return _Number$isInteger(value) ? value : -1;
    }
  }, {
    key: "flush",
    value: function flush() {
      this.segmentCache = new _Map();
      this.segmentChangeNumber = new _Map();
    }
  }]);

  return SegmentCacheInMemory;
}();

export default SegmentCacheInMemory;