import _Number$isNaN from 'babel-runtime/core-js/number/is-nan';
import _Promise from 'babel-runtime/core-js/promise';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';

var SegmentCacheInRedis = function () {
  function SegmentCacheInRedis(keys, redis) {
    _classCallCheck(this, SegmentCacheInRedis);

    this.redis = redis;
    this.keys = keys;
  }

  _createClass(SegmentCacheInRedis, [{
    key: 'addToSegment',
    value: function addToSegment(segmentName, segmentKeys) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      if (segmentKeys.length) {
        return this.redis.sadd(segmentKey, segmentKeys).then(function () {
          return true;
        });
      } else {
        return _Promise.resolve(true);
      }
    }
  }, {
    key: 'removeFromSegment',
    value: function removeFromSegment(segmentName, segmentKeys) {
      var segmentKey = this.keys.buildSegmentNameKey(segmentName);

      if (segmentKeys.length) {
        return this.redis.srem(segmentKey, segmentKeys).then(function () {
          return true;
        });
      } else {
        return _Promise.resolve(true);
      }
    }
  }, {
    key: 'isInSegment',
    value: function isInSegment(segmentName, key) {
      return this.redis.sismember(this.keys.buildSegmentNameKey(segmentName), key).then(function (matches) {
        return matches !== 0;
      });
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber(segmentName, changeNumber) {
      return this.redis.set(this.keys.buildSegmentTillKey(segmentName), changeNumber + '').then(function (status) {
        return status === 'OK';
      });
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber(segmentName) {
      return this.redis.get(this.keys.buildSegmentTillKey(segmentName)).then(function (value) {
        var i = parseInt(value, 10);

        return _Number$isNaN(i) ? -1 : i;
      });
    }
  }, {
    key: 'registerSegment',
    value: function registerSegment(segment) {
      return this.registerSegments(segment);
    }
  }, {
    key: 'registerSegments',
    value: function registerSegments(segments) {
      if (segments.length) {
        return this.redis.sadd(this.keys.buildRegisteredSegmentsKey(), segments).then(function () {
          return true;
        });
      } else {
        return _Promise.resolve(true);
      }
    }
  }, {
    key: 'getRegisteredSegments',
    value: function getRegisteredSegments() {
      return this.redis.smembers(this.keys.buildRegisteredSegmentsKey());
    }
  }, {
    key: 'flush',
    value: function flush() {
      return this.redis.flushdb().then(function (status) {
        return status === 'OK';
      });
    }
  }]);

  return SegmentCacheInRedis;
}();

export default SegmentCacheInRedis;