import _Map from 'babel-runtime/core-js/map';
import _toConsumableArray from 'babel-runtime/helpers/toConsumableArray';
import _getIterator from 'babel-runtime/core-js/get-iterator';
import _slicedToArray from 'babel-runtime/helpers/slicedToArray';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import { isFinite } from '../../utils/lang';
import usesSegments from '../../utils/splits/usesSegments';

var SplitCacheInMemory = function () {
  function SplitCacheInMemory() {
    _classCallCheck(this, SplitCacheInMemory);

    this.flush();
  }

  _createClass(SplitCacheInMemory, [{
    key: 'addSplit',
    value: function addSplit(splitName, split) {
      var splitFromMemory = this.getSplit(splitName);
      if (splitFromMemory) {
        // We had this Split already
        var previousSplit = JSON.parse(splitFromMemory);

        if (previousSplit.trafficTypeName) {
          var previousTtName = previousSplit.trafficTypeName;
          this.ttCache[previousTtName]--;
          if (!this.ttCache[previousTtName]) delete this.ttCache[previousTtName];
        }

        if (usesSegments(previousSplit.conditions)) {
          // Substract from segments count for the previous version of this Split.
          this.splitsWithSegmentsCount--;
        }
      }

      var parsedSplit = JSON.parse(split);

      if (parsedSplit) {
        // Store the Split.
        this.splitCache.set(splitName, split);
        // Update TT cache
        var ttName = parsedSplit.trafficTypeName;
        if (ttName) {
          // safeguard
          if (!this.ttCache[ttName]) this.ttCache[ttName] = 0;
          this.ttCache[ttName]++;
        }

        // Add to segments count for the new version of the Split
        if (usesSegments(parsedSplit.conditions)) this.splitsWithSegmentsCount++;

        return true;
      } else {
        return false;
      }
    }
  }, {
    key: 'addSplits',
    value: function addSplits(entries) {
      var results = [];

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = _getIterator(entries), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var _ref = _step.value;

          var _ref2 = _slicedToArray(_ref, 2);

          var key = _ref2[0];
          var value = _ref2[1];

          results.push(this.addSplit(key, value));
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return results;
    }
  }, {
    key: 'removeSplit',
    value: function removeSplit(splitName) {
      var split = this.getSplit(splitName);
      if (split) {
        // Delete the Split
        this.splitCache.delete(splitName);

        var parsedSplit = JSON.parse(split);
        var ttName = parsedSplit.trafficTypeName;

        if (ttName) {
          // safeguard
          this.ttCache[ttName]--; // Update tt cache
          if (!this.ttCache[ttName]) delete this.ttCache[ttName];
        }

        // Update the segments count.
        if (usesSegments(parsedSplit.conditions)) this.splitsWithSegmentsCount--;

        return 1;
      } else {
        return 0;
      }
    }
  }, {
    key: 'removeSplits',
    value: function removeSplits(splitNames) {
      var _this = this;

      splitNames.forEach(function (n) {
        return _this.removeSplit(n);
      });

      return splitNames.length;
    }
  }, {
    key: 'getSplit',
    value: function getSplit(splitName) {
      return this.splitCache.get(splitName);
    }
  }, {
    key: 'setChangeNumber',
    value: function setChangeNumber(changeNumber) {
      this.changeNumber = changeNumber;

      return true;
    }
  }, {
    key: 'getChangeNumber',
    value: function getChangeNumber() {
      return this.changeNumber;
    }
  }, {
    key: 'getAll',
    value: function getAll() {
      return [].concat(_toConsumableArray(this.splitCache.values()));
    }
  }, {
    key: 'getKeys',
    value: function getKeys() {
      return [].concat(_toConsumableArray(this.splitCache.keys()));
    }
  }, {
    key: 'trafficTypeExists',
    value: function trafficTypeExists(trafficType) {
      return isFinite(this.ttCache[trafficType]) && this.ttCache[trafficType] > 0;
    }
  }, {
    key: 'usesSegments',
    value: function usesSegments() {
      return this.getChangeNumber() === -1 || this.splitsWithSegmentsCount > 0;
    }
  }, {
    key: 'flush',
    value: function flush() {
      this.splitCache = new _Map();
      this.ttCache = {};
      this.changeNumber = -1;
      this.splitsWithSegmentsCount = 0;
    }
  }]);

  return SplitCacheInMemory;
}();

export default SplitCacheInMemory;