/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

import logFactory from '../utils/logger';
import thenable from '../utils/promise/thenable';
var log = logFactory('splitio-client:impression-tracker');

function ImpressionsTrackerContext(context) {
  var collector = context.get(context.constants.STORAGE).impressions;
  var settings = context.get(context.constants.SETTINGS);
  var listener = settings.impressionListener;
  var _settings$runtime = settings.runtime,
      ip = _settings$runtime.ip,
      hostname = _settings$runtime.hostname;

  var sdkLanguageVersion = settings.version;

  return {
    track: function track(impression, attributes) {
      var res = collector.track([impression]);

      // If we're on an async storage, handle error and log it.
      if (thenable(res)) res.catch(function (err) {
        log.error('Could not store impression. Error: ' + err);
      });

      // Wrap in a timeout because we don't want it to be blocking.
      listener && setTimeout(function () {
        try {
          // An exception on the listener should not break the SDK.
          listener.logImpression({
            impression: impression,
            attributes: attributes,
            ip: ip,
            hostname: hostname,
            sdkLanguageVersion: sdkLanguageVersion
          });
        } catch (err) {
          log.error('Impression listener logImpression method threw: ' + err + '.');
        }
      }, 0);
    }
  };
}

export default ImpressionsTrackerContext;