import _Object$assign from 'babel-runtime/core-js/object/assign';
import _Promise from 'babel-runtime/core-js/promise';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
import thenable from '../promise/thenable';
import constants from './constants';

var Context = function () {
  function Context() {
    _classCallCheck(this, Context);

    this._map = {};
    this.constants = constants;
  }
  /**
   * Gets an item in the context instance or a promise if the item is not yet stored and we are not doing a one time check.
   * @param {String} name - The name of the item we want to get
   * @return {Any} The item we want to get.
   */


  _createClass(Context, [{
    key: 'get',
    value: function get(name) {
      var flagCheck = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (typeof name !== 'string' || typeof name === 'string' && !name.length) return; // Wrong usage, don't generate item promise.

      var item = this._map[name];

      // If we have the item, return it.
      if (item !== undefined) {
        return item;
      } else if (!flagCheck) {
        // If we don't and it's not a flag check, return a promise that we will resolve once we receive the item.
        var resolve = void 0;
        var promise = new _Promise(function (res) {
          return resolve = res;
        });
        promise.manualResolve = resolve;
        this._map[name] = promise;
        return promise;
      }
    }
    /**
     * Gets all objects stored in the context.
     * @return {Object} - A new map of context-stored items.
     */

  }, {
    key: 'getAll',
    value: function getAll() {
      return _Object$assign({}, this._map);
    }
    /**
     * Stores an item in the context instance.
     * @param {String} name - The name of what we are storing
     * @param {Any} item - The item can be of any type.
     * @return {Boolean} - The result of the operation
     */

  }, {
    key: 'put',
    value: function put(name, item) {
      var _this = this;

      if (typeof name !== 'string' || typeof name === 'string' && !name.length || item === undefined) return false; // We can't store this.

      var existingItem = this._map[name];

      // Item already exists and no one is waiting for the item. Abort and return false.
      if (existingItem !== undefined && typeof existingItem.manualResolve !== 'function') return false;

      // Someone is waiting for this item, resolve to it.
      if (thenable(existingItem) && existingItem.manualResolve) existingItem.manualResolve(item);

      // We are storing a promise, when resolving save the item. On error, clean up the item.
      if (thenable(item)) {
        item.then(function (item) {
          _this._map[name] = item;
          return item;
        }).catch(function (err) {
          _this._map[name] = undefined;
          return err;
        });
      }

      this._map[name] = item;
      return true;
    }
  }]);

  return Context;
}();

export default Context;