/* eslint-disable no-console */
'use strict';

import _Object$keys from 'babel-runtime/core-js/object/keys';
import _Object$assign from 'babel-runtime/core-js/object/assign';
import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
var isNode = typeof process !== 'undefined' && process.version ? true : false;

export var LogLevels = {
  'DEBUG': 'DEBUG',
  'INFO': 'INFO',
  'WARN': 'WARN',
  'ERROR': 'ERROR',
  'NONE': 'NONE'
};

// DEBUG is the default. The log level is not specific to an SDK instance.
var GlobalLogLevel = LogLevels.DEBUG;

export var setLogLevel = function setLogLevel(level) {
  GlobalLogLevel = level;
};

var defaultOptions = {
  showLevel: true,
  displayAllErrors: false
};

export var Logger = function () {
  function Logger(category, options) {
    _classCallCheck(this, Logger);

    this.category = category;
    this.options = _Object$assign({}, defaultOptions, options);
  }

  _createClass(Logger, [{
    key: 'debug',
    value: function debug(msg) {
      if (this._shouldLog(LogLevels.DEBUG)) this._log(LogLevels.DEBUG, msg);
    }
  }, {
    key: 'info',
    value: function info(msg) {
      if (this._shouldLog(LogLevels.INFO)) this._log(LogLevels.INFO, msg);
    }
  }, {
    key: 'warn',
    value: function warn(msg) {
      if (this._shouldLog(LogLevels.WARN)) this._log(LogLevels.WARN, msg);
    }
  }, {
    key: 'error',
    value: function error(msg) {
      if (this.options.displayAllErrors || this._shouldLog(LogLevels.ERROR)) this._log(LogLevels.ERROR, msg);
    }
  }, {
    key: '_log',
    value: function _log(level, text) {
      var formattedText = this._generateLogMessage(level, text);
      var method = level === LogLevels.ERROR && !isNode ? 'error' : 'log';

      console[method](formattedText);
    }
  }, {
    key: '_generateLogMessage',
    value: function _generateLogMessage(level, text) {
      var textPre = ' => ';
      var result = '';

      if (this.options.showLevel) {
        result += '[' + level + ']' + (level === LogLevels.INFO || level === LogLevels.WARN ? ' ' : '') + ' ';
      }

      if (this.category) {
        result += this.category + textPre;
      }

      return result += text;
    }
  }, {
    key: '_shouldLog',
    value: function _shouldLog(level) {
      var logLevel = GlobalLogLevel;
      var levels = _Object$keys(LogLevels).map(function (f) {
        return LogLevels[f];
      });
      var index = levels.indexOf(level); // What's the index of what it's trying to check if it should log
      var levelIdx = levels.indexOf(logLevel); // What's the current log level index.

      return index >= levelIdx;
    }
  }]);

  return Logger;
}();