/**
 * Given a list of conditions, it returns a boolean flagging if those conditions 
 * use segments matchers (rules & whitelists)
 */
function usesSegments() {
  var conditions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];

  for (var i = 0; i < conditions.length; i++) {
    var matchers = conditions[i].matcherGroup.matchers;

    for (var j = 0; j < matchers.length; j++) {
      if (matchers[j].matcherType === 'IN_SEGMENT') return true;
    }
  }

  return false;
}

export default usesSegments;