'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lang = require('../utils/lang');

var _inputValidation = require('./inputValidation');

var _inputValidation2 = _interopRequireDefault(_inputValidation);

var _constants = require('../utils/constants');

var _inputValidation3 = require('../utils/inputValidation');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function BrowserClientFactory(context) {
  var _client$track;

  var settings = context.get(context.constants.SETTINGS);
  var maybeKey = (0, _lang.get)(settings, 'core.key', undefined);
  var maybeTT = (0, _lang.get)(settings, 'core.trafficType', undefined);

  if (settings.mode === _constants.LOCALHOST_MODE && maybeKey === undefined) {
    settings.core.key = 'localhost_key';
  } else {
    settings.core.key = (0, _inputValidation3.validateKey)(maybeKey, 'Client instantiation');
  }

  // Key is also binded to the .track method. Same thing happens with trafficType but only if present on configs. (not required)
  var trackBindings = [settings.core.key];
  if (maybeTT !== undefined) {
    var tt = (0, _inputValidation3.validateTrafficType)(maybeTT, 'Client instantiation');
    settings.core.trafficType = tt;
    trackBindings.push(tt);
  }

  var client = (0, _inputValidation2.default)(context, true, trackBindings.length > 1);
  client.isBrowserClient = true;

  // In the browser land, we can bind the key and the traffic type (if provided)
  client.getTreatment = client.getTreatment.bind(client, settings.core.key);
  client.getTreatmentWithConfig = client.getTreatmentWithConfig.bind(client, settings.core.key);
  client.getTreatments = client.getTreatments.bind(client, settings.core.key);
  client.getTreatmentsWithConfig = client.getTreatmentsWithConfig.bind(client, settings.core.key);
  client.track = (_client$track = client.track).bind.apply(_client$track, [client].concat(trackBindings));

  return client;
}

exports.default = BrowserClientFactory;
module.exports = exports.default;