'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _client = require('./client');

var _client2 = _interopRequireDefault(_client);

var _inputValidation = require('../utils/inputValidation');

var _lang = require('../utils/lang');

var _constants = require('../utils/constants');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * We will validate the input before actually executing the client methods. We should "guard" the client here,
 * while not polluting the "real" implementation of those methods.
 */
function ClientInputValidationLayer(context, isKeyBinded, isTTBinded) {
  var settings = context.get(context.constants.SETTINGS);
  var isStorageSync = settings.storage.type !== _constants.STORAGE_REDIS;
  // instantiate the client
  var client = (0, _client2.default)(context);
  // Keep a reference to the original methods
  var clientGetTreatment = client.getTreatment;
  var clientGetTreatmentWithConfig = client.getTreatmentWithConfig;
  var clientGetTreatments = client.getTreatments;
  var clientGetTreatmentsWithConfig = client.getTreatmentsWithConfig;
  var clientTrack = client.track;

  /**
   * Avoid repeating this validations code
   */
  function validateEvaluationParams(maybeKey, maybeSplitOrSplits, maybeAttributes, methodName) {
    var multi = (0, _lang.startsWith)(methodName, 'getTreatments');
    var key = isKeyBinded ? maybeKey : (0, _inputValidation.validateKey)(maybeKey, methodName);
    var splitOrSplits = multi ? (0, _inputValidation.validateSplits)(maybeSplitOrSplits, methodName) : (0, _inputValidation.validateSplit)(maybeSplitOrSplits, methodName);
    var attributes = (0, _inputValidation.validateAttributes)(maybeAttributes, methodName);
    var isOperational = (0, _inputValidation.validateIfDestroyed)(context);

    (0, _inputValidation.validateIfReady)(context, methodName);

    var valid = isOperational && key && splitOrSplits && attributes !== false;

    return {
      valid: valid,
      key: key,
      splitOrSplits: splitOrSplits,
      attributes: attributes
    };
  }

  client.getTreatment = function getTreatment(maybeKey, maybeSplit, maybeAttributes) {
    var params = validateEvaluationParams(maybeKey, maybeSplit, maybeAttributes, 'getTreatment');

    if (params.valid) {
      return clientGetTreatment(params.key, params.splitOrSplits, params.attributes);
    } else {
      if (isStorageSync) return _constants.CONTROL;

      return _promise2.default.resolve(_constants.CONTROL);
    }
  };

  client.getTreatmentWithConfig = function getTreatmentWithConfig(maybeKey, maybeSplit, maybeAttributes) {
    var params = validateEvaluationParams(maybeKey, maybeSplit, maybeAttributes, 'getTreatmentWithConfig');

    if (params.valid) {
      return clientGetTreatmentWithConfig(params.key, params.splitOrSplits, params.attributes);
    } else {
      if (isStorageSync) return (0, _assign2.default)({}, _constants.CONTROL_WITH_CONFIG);

      return _promise2.default.resolve((0, _assign2.default)({}, _constants.CONTROL_WITH_CONFIG));
    }
  };

  client.getTreatments = function getTreatments(maybeKey, maybeSplits, maybeAttributes) {
    var params = validateEvaluationParams(maybeKey, maybeSplits, maybeAttributes, 'getTreatments');

    if (params.valid) {
      return clientGetTreatments(params.key, params.splitOrSplits, params.attributes);
    } else {
      var res = {};
      if (params.splitOrSplits) params.splitOrSplits.forEach(function (split) {
        return res[split] = _constants.CONTROL;
      });

      if (isStorageSync) return res;

      return _promise2.default.resolve(res);
    }
  };

  client.getTreatmentsWithConfig = function getTreatmentsWithConfig(maybeKey, maybeSplits, maybeAttributes) {
    var params = validateEvaluationParams(maybeKey, maybeSplits, maybeAttributes, 'getTreatmentsWithConfig');

    if (params.valid) {
      return clientGetTreatmentsWithConfig(params.key, params.splitOrSplits, params.attributes);
    } else {
      var res = {};
      if (params.splitOrSplits) params.splitOrSplits.forEach(function (split) {
        return res[split] = (0, _assign2.default)({}, _constants.CONTROL_WITH_CONFIG);
      });

      if (isStorageSync) return res;

      return _promise2.default.resolve(res);
    }
  };

  client.track = function track(maybeKey, maybeTT, maybeEvent, maybeEventValue, maybeProperties) {
    var key = isKeyBinded ? maybeKey : (0, _inputValidation.validateKey)(maybeKey, 'track');
    var tt = isTTBinded ? maybeTT : (0, _inputValidation.validateTrafficType)(maybeTT, 'track');
    var event = (0, _inputValidation.validateEvent)(maybeEvent, 'track');
    var eventValue = (0, _inputValidation.validateEventValue)(maybeEventValue, 'track');

    var _validateEventPropert = (0, _inputValidation.validateEventProperties)(maybeProperties),
        properties = _validateEventPropert.properties,
        size = _validateEventPropert.size;

    var isOperational = (0, _inputValidation.validateIfDestroyed)(context);

    if (isOperational && key && tt && event && eventValue !== false && properties !== false) {
      return clientTrack(key, tt, event, eventValue, properties, size);
    } else {
      if (isStorageSync) return false;

      return _promise2.default.resolve(false);
    }
  };

  return client;
}

exports.default = ClientInputValidationLayer;
module.exports = exports.default;