'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _lang = require('../../utils/lang');

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _labels = require('../../utils/labels');

var LabelsConstants = _interopRequireWildcard(_labels);

var _constants = require('../../utils/constants');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var log = (0, _logger2.default)('splitio-engine:combiner');


function unexpectedInputHandler() {
  log.error('Invalid Split provided, no valid conditions found');

  return {
    treatment: _constants.CONTROL,
    label: LabelsConstants.EXCEPTION
  };
}

function computeTreatment(predicateResults) {
  var len = predicateResults.length;

  for (var i = 0; i < len; i++) {
    var evaluation = predicateResults[i];

    if (evaluation !== undefined) {
      log.debug('Treatment found: ' + evaluation.treatment);

      return evaluation;
    }
  }

  log.debug('All predicates evaluated, no treatment found.');
  return undefined;
}

function ifElseIfCombinerContext(predicates) {

  function ifElseIfCombiner(key, seed, trafficAllocation, trafficAllocationSeed, attributes, algo, splitEvaluator) {
    // In Async environments we are going to have async predicates. There is none way to know
    // before hand so we need to evaluate all the predicates, verify for thenables, and finally,
    // define how to return the treatment (wrap result into a Promise or not).
    var predicateResults = predicates.map(function (evaluator) {
      return evaluator(key, seed, trafficAllocation, trafficAllocationSeed, splitEvaluator, attributes, algo);
    });

    // if we find a thenable
    if ((0, _lang.findIndex)(predicateResults, _thenable2.default) !== -1) {
      return _promise2.default.all(predicateResults).then(function (results) {
        return computeTreatment(results);
      });
    }

    return computeTreatment(predicateResults);
  }

  // if there is none predicates, then there was an error in parsing phase
  if (!Array.isArray(predicates) || Array.isArray(predicates) && predicates.length === 0) {
    return unexpectedInputHandler;
  } else {
    return ifElseIfCombiner;
  }
}

exports.default = ifElseIfCombinerContext;
module.exports = exports.default;