'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _engine = require('../engine');

var _engine2 = _interopRequireDefault(_engine);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _labels = require('../../utils/labels');

var LabelsConstants = _interopRequireWildcard(_labels);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Build Evaluation object if and only if matchingResult is true
function match(matchingResult, bucketingKey, seed, treatments, label, algo) {
  if (matchingResult) {
    var treatment = _engine2.default.getTreatment(bucketingKey, seed, treatments, algo);

    return {
      treatment: treatment,
      label: label
    };
  }

  // else we should notify the engine to continue evaluating
  return undefined;
}

// Condition factory
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

function conditionContext(matcherEvaluator, treatments, label, conditionType) {

  function conditionEvaluator(key, seed, trafficAllocation, trafficAllocationSeed, splitEvaluator, attributes, algo) {

    // Whitelisting has more priority than traffic allocation, so we don't apply this filtering to those conditions.
    if (conditionType === 'ROLLOUT' && !_engine2.default.shouldApplyRollout(trafficAllocation, key.bucketingKey, trafficAllocationSeed, algo)) {
      return {
        treatment: undefined,
        label: LabelsConstants.NOT_IN_SPLIT
      };
    }

    // matcherEvaluator could be Async, this relays on matchers return value, so we need
    // to verify for thenable before play with the result.
    // Also, we pass splitEvaluator function in case we have a matcher that needs to evaluate another split,
    // as well as the entire key object for the same reason.
    var matches = matcherEvaluator(key, attributes, splitEvaluator);

    if ((0, _thenable2.default)(matches)) {
      return matches.then(function (result) {
        return match(result, key.bucketingKey, seed, treatments, label, algo);
      });
    }

    return match(matches, key.bucketingKey, seed, treatments, label, algo);
  }

  return conditionEvaluator;
}

exports.default = conditionContext;
module.exports = exports.default;