'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _ = require('../');

var _2 = _interopRequireDefault(_);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _labels = require('../../utils/labels');

var LabelsConstants = _interopRequireWildcard(_labels);

var _lang = require('../../utils/lang');

var _constants = require('../../utils/constants');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function splitEvaluator(key, splitName, attributes, storage) {
  var stringifiedSplit = void 0;

  try {
    stringifiedSplit = storage.splits.getSplit(splitName);
  } catch (e) {
    // the only scenario where getSplit can throw an error is when the storage
    // is redis and there is a connection issue and we can't retrieve the split
    // to be evaluated
    return _promise2.default.resolve({
      treatment: _constants.CONTROL,
      label: LabelsConstants.EXCEPTION,
      config: null
    });
  }

  if ((0, _thenable2.default)(stringifiedSplit)) {
    return stringifiedSplit.then(function (result) {
      return getEvaluation(result, key, attributes, storage);
    });
  }

  return getEvaluation(stringifiedSplit, key, attributes, storage);
} /**
  Copyright 2016 Split Software
  
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
      http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  **/

function getEvaluation(stringifiedSplit, key, attributes, storage) {
  var evaluation = {
    treatment: _constants.CONTROL,
    label: LabelsConstants.SPLIT_NOT_FOUND,
    config: null
  };

  if (stringifiedSplit) {
    var splitJSON = JSON.parse(stringifiedSplit);
    var split = _2.default.parse(splitJSON, storage);
    evaluation = split.getTreatment(key, attributes, splitEvaluator);

    // If the storage is async, evaluation and changeNumber will return a thenable
    if ((0, _thenable2.default)(evaluation)) {
      return evaluation.then(function (result) {
        result.changeNumber = split.getChangeNumber();
        result.config = (0, _lang.get)(splitJSON, 'configurations.' + result.treatment, null);

        return result;
      });
    } else {
      evaluation.changeNumber = split.getChangeNumber(); // Always sync and optional
      evaluation.config = (0, _lang.get)(splitJSON, 'configurations.' + evaluation.treatment, null);
    }
  }

  return evaluation;
}

exports.default = splitEvaluator;
module.exports = exports.default;