'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _lang = require('../utils/lang');

var _parser = require('./parser');

var _parser2 = _interopRequireDefault(_parser);

var _parser3 = require('../utils/key/parser');

var _parser4 = _interopRequireDefault(_parser3);

var _thenable = require('../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _labels = require('../utils/labels');

var LabelsConstants = _interopRequireWildcard(_labels);

var _constants = require('../utils/constants');

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

function defaults(inst) {
  // in case we don't have a default treatment in the instanciation, use 'control'
  if (typeof inst.baseInfo.defaultTreatment !== 'string') {
    inst.baseInfo.defaultTreatment = _constants.CONTROL;
  }
}

function evaluationResult(result, defaultTreatment) {
  return {
    treatment: (0, _lang.get)(result, 'treatment', defaultTreatment),
    label: (0, _lang.get)(result, 'label', LabelsConstants.NO_CONDITION_MATCH)
  };
}

function Split(baseInfo, evaluator) {
  if (!(this instanceof Split)) {
    return new Split(baseInfo, evaluator);
  }

  this.baseInfo = baseInfo;
  this.evaluator = evaluator;

  defaults(this);
}

Split.parse = function parse(splitFlatStructure, storage) {
  var conditions = splitFlatStructure.conditions,
      baseInfo = (0, _objectWithoutProperties3.default)(splitFlatStructure, ['conditions']);

  var evaluator = (0, _parser2.default)(conditions, storage);

  return new Split(baseInfo, evaluator);
};

Split.prototype.getKey = function getKey() {
  return this.baseInfo.name;
};

Split.prototype.getTreatment = function getTreatment(key, attributes, splitEvaluator) {
  var _baseInfo = this.baseInfo,
      killed = _baseInfo.killed,
      seed = _baseInfo.seed,
      defaultTreatment = _baseInfo.defaultTreatment,
      trafficAllocation = _baseInfo.trafficAllocation,
      trafficAllocationSeed = _baseInfo.trafficAllocationSeed,
      algo = _baseInfo.algo;

  var parsedKey = void 0;
  var treatment = void 0;
  var label = void 0;

  try {
    parsedKey = (0, _parser4.default)(key);
  } catch (err) {
    return {
      treatment: _constants.CONTROL,
      label: LabelsConstants.EXCEPTION
    };
  }

  if (this.isGarbage()) {
    treatment = _constants.CONTROL;
    label = LabelsConstants.SPLIT_ARCHIVED;
  } else if (killed) {
    treatment = defaultTreatment;
    label = LabelsConstants.SPLIT_KILLED;
  } else {
    var evaluation = this.evaluator(parsedKey, seed, trafficAllocation, trafficAllocationSeed, attributes, algo, splitEvaluator);

    // Evaluation could be async, so we should handle that case checking for a
    // thenable object
    if ((0, _thenable2.default)(evaluation)) {
      return evaluation.then(function (result) {
        return evaluationResult(result, defaultTreatment);
      });
    } else {
      return evaluationResult(evaluation, defaultTreatment);
    }
  }

  return {
    treatment: treatment,
    label: label
  };
};

Split.prototype.isGarbage = function isGarbage() {
  return this.baseInfo.status === 'ARCHIVED';
};

Split.prototype.getChangeNumber = function getChangeNumber() {
  return this.baseInfo.changeNumber;
};

exports.default = Split;
module.exports = exports.default;