'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lang = require('../../utils/lang');

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var log = (0, _logger2.default)('splitio-engine:matcher');

function containsStringMatcherContext(ruleAttr /*: array */) /*: Function */{
  return function containsStringMatcher(runtimeAttr /*: string */) /*: boolean */{
    var contains = ruleAttr.some(function (e) {
      return (0, _lang.isString)(runtimeAttr) && runtimeAttr.indexOf(e) > -1;
    });

    log.debug('[containsStringMatcher] ' + runtimeAttr + ' contains ' + ruleAttr + '? ' + contains);

    return contains;
  };
}

exports.default = containsStringMatcherContext;
module.exports = exports.default;