'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-engine:matcher'); /**
                                                           Copyright 2016 Split Software
                                                           
                                                           Licensed under the Apache License, Version 2.0 (the "License");
                                                           you may not use this file except in compliance with the License.
                                                           You may obtain a copy of the License at
                                                           
                                                               http://www.apache.org/licenses/LICENSE-2.0
                                                           
                                                           Unless required by applicable law or agreed to in writing, software
                                                           distributed under the License is distributed on an "AS IS" BASIS,
                                                           WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                           See the License for the specific language governing permissions and
                                                           limitations under the License.
                                                           **/


function checkTreatment(evaluation, acceptableTreatments, parentName) {
  var matches = false;

  if (Array.isArray(acceptableTreatments)) {
    matches = acceptableTreatments.indexOf(evaluation.treatment) !== -1;
  }

  log.debug('[dependencyMatcher] Parent split "' + parentName + '" evaluated to "' + evaluation.treatment + '" with label "' + evaluation.label + '". ' + parentName + ' evaluated treatment is part of [' + acceptableTreatments + '] ? ' + matches + '.');

  return matches;
}

function dependencyMatcherContext(_ref, storage) {
  var split = _ref.split,
      treatments = _ref.treatments;


  return function dependencyMatcher(_ref2, splitEvaluator) {
    var key = _ref2.key,
        attributes = _ref2.attributes;

    log.debug('[dependencyMatcher] will evaluate parent split: "' + split + '" with key: ' + (0, _stringify2.default)(key) + ' ' + (attributes ? '\n attributes: ' + (0, _stringify2.default)(attributes) : ''));
    var evaluation = splitEvaluator(key, split, attributes, storage);

    if ((0, _thenable2.default)(evaluation)) {
      return evaluation.then(function (ev) {
        return checkTreatment(ev, treatments, split);
      });
    } else {
      return checkTreatment(evaluation, treatments, split);
    }
  };
}

exports.default = dependencyMatcherContext;
module.exports = exports.default;