'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-engine:matcher'); /**
                                                           Copyright 2016 Split Software
                                                           
                                                           Licensed under the Apache License, Version 2.0 (the "License");
                                                           you may not use this file except in compliance with the License.
                                                           You may obtain a copy of the License at
                                                           
                                                               http://www.apache.org/licenses/LICENSE-2.0
                                                           
                                                           Unless required by applicable law or agreed to in writing, software
                                                           distributed under the License is distributed on an "AS IS" BASIS,
                                                           WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                           See the License for the specific language governing permissions and
                                                           limitations under the License.
                                                           **/

function equalToMatcherContext(ruleAttr /*: number */) /*: Function */{
  return function equalToMatcher(runtimeAttr /*: number */) /*: boolean */{
    var isEqual = runtimeAttr === ruleAttr;

    log.debug('[equalToMatcher] is ' + runtimeAttr + ' equal to ' + ruleAttr + '? ' + isEqual);

    return isEqual;
  };
}

exports.default = equalToMatcherContext;
module.exports = exports.default;