'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _types = require('./types');

var _all = require('./all');

var _all2 = _interopRequireDefault(_all);

var _segment = require('./segment');

var _segment2 = _interopRequireDefault(_segment);

var _whitelist = require('./whitelist');

var _whitelist2 = _interopRequireDefault(_whitelist);

var _eq = require('./eq');

var _eq2 = _interopRequireDefault(_eq);

var _gte = require('./gte');

var _gte2 = _interopRequireDefault(_gte);

var _lte = require('./lte');

var _lte2 = _interopRequireDefault(_lte);

var _between = require('./between');

var _between2 = _interopRequireDefault(_between);

var _eq_set = require('./eq_set');

var _eq_set2 = _interopRequireDefault(_eq_set);

var _cont_all = require('./cont_all');

var _cont_all2 = _interopRequireDefault(_cont_all);

var _cont_any = require('./cont_any');

var _cont_any2 = _interopRequireDefault(_cont_any);

var _part_of = require('./part_of');

var _part_of2 = _interopRequireDefault(_part_of);

var _sw = require('./sw');

var _sw2 = _interopRequireDefault(_sw);

var _ew = require('./ew');

var _ew2 = _interopRequireDefault(_ew);

var _cont_str = require('./cont_str');

var _cont_str2 = _interopRequireDefault(_cont_str);

var _dependency = require('./dependency');

var _dependency2 = _interopRequireDefault(_dependency);

var _boolean = require('./boolean');

var _boolean2 = _interopRequireDefault(_boolean);

var _string = require('./string');

var _string2 = _interopRequireDefault(_string);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Matcher factory.
 */
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
function MatcherFactory(matcherDto, storage) {
  var type = matcherDto.type,
      value = matcherDto.value;


  var matcherFn = void 0;

  if (type === _types.types.ALL) {
    matcherFn = (0, _all2.default)(value);
  } else if (type === _types.types.SEGMENT) {
    matcherFn = (0, _segment2.default)(value, storage);
  } else if (type === _types.types.WHITELIST) {
    matcherFn = (0, _whitelist2.default)(value);
  } else if (type === _types.types.EQUAL_TO) {
    matcherFn = (0, _eq2.default)(value);
  } else if (type === _types.types.GREATER_THAN_OR_EQUAL_TO) {
    matcherFn = (0, _gte2.default)(value);
  } else if (type === _types.types.LESS_THAN_OR_EQUAL_TO) {
    matcherFn = (0, _lte2.default)(value);
  } else if (type === _types.types.BETWEEN) {
    matcherFn = (0, _between2.default)(value);
  } else if (type === _types.types.EQUAL_TO_SET) {
    matcherFn = (0, _eq_set2.default)(value);
  } else if (type === _types.types.CONTAINS_ANY_OF_SET) {
    matcherFn = (0, _cont_any2.default)(value);
  } else if (type === _types.types.CONTAINS_ALL_OF_SET) {
    matcherFn = (0, _cont_all2.default)(value);
  } else if (type === _types.types.PART_OF_SET) {
    matcherFn = (0, _part_of2.default)(value);
  } else if (type === _types.types.STARTS_WITH) {
    matcherFn = (0, _sw2.default)(value);
  } else if (type === _types.types.ENDS_WITH) {
    matcherFn = (0, _ew2.default)(value);
  } else if (type === _types.types.CONTAINS_STRING) {
    matcherFn = (0, _cont_str2.default)(value);
  } else if (type === _types.types.IN_SPLIT_TREATMENT) {
    matcherFn = (0, _dependency2.default)(value, storage);
  } else if (type === _types.types.EQUAL_TO_BOOLEAN) {
    matcherFn = (0, _boolean2.default)(value);
  } else if (type === _types.types.MATCHES_STRING) {
    matcherFn = (0, _string2.default)(value);
  }

  return matcherFn;
}

exports.default = MatcherFactory;
module.exports = exports.default;