'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _lang = require('../../utils/lang');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var log = (0, _logger2.default)('splitio-engine:matcher');

function partOfMatcherContext(ruleAttr /*: array */) /*: Function */{
  return function partOfMatcher(runtimeAttr /*: array */) /*: boolean */{
    // To be part of the length should be minor or equal.
    var isPartOf = runtimeAttr.length <= ruleAttr.length;

    var _loop = function _loop(i) {
      // If the length says is possible, we iterate until we prove otherwise or we check all elements.
      if ((0, _lang.findIndex)(ruleAttr, function (e) {
        return e === runtimeAttr[i];
      }) < 0) isPartOf = false;
    };

    for (var i = 0; i < runtimeAttr.length && isPartOf; i++) {
      _loop(i);
    }

    log.debug('[partOfMatcher] ' + runtimeAttr + ' is part of ' + ruleAttr + '? ' + isPartOf);

    return isPartOf;
  };
}

exports.default = partOfMatcherContext;
module.exports = exports.default;