'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _matchers = require('../transforms/matchers');

var _matchers2 = _interopRequireDefault(_matchers);

var _treatments = require('../treatments');

var _treatments2 = _interopRequireDefault(_treatments);

var _matchers3 = require('../matchers');

var _matchers4 = _interopRequireDefault(_matchers3);

var _value = require('../value');

var _value2 = _interopRequireDefault(_value);

var _condition = require('../condition');

var _condition2 = _interopRequireDefault(_condition);

var _ifelseif = require('../combiners/ifelseif');

var _ifelseif2 = _interopRequireDefault(_ifelseif);

var _and = require('../combiners/and');

var _and2 = _interopRequireDefault(_and);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

function parse(conditions, storage) {
  var predicates = [];

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = (0, _getIterator3.default)(conditions), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var condition = _step.value;
      var matchers = condition.matcherGroup.matchers,
          partitions = condition.partitions,
          label = condition.label,
          conditionType = condition.conditionType;

      // transform data structure

      matchers = (0, _matchers2.default)(matchers);

      // create a set of pure functions from the matcher's dto
      var expressions = matchers.map(function (matcherDto) {
        var matcher = (0, _matchers4.default)(matcherDto, storage);

        // Evaluator function.
        return function (key, attributes, splitEvaluator) {
          var value = (0, _value2.default)(key, matcherDto, attributes);
          var result = value !== undefined ? matcher(value, splitEvaluator) : false;

          if ((0, _thenable2.default)(result)) {
            return result.then(function (res) {
              return Boolean(res ^ matcherDto.negate);
            });
          }
          return Boolean(result ^ matcherDto.negate);
        };
      });

      // if matcher's factory can't instanciate the matchers, the expressions array
      // will be empty
      if (expressions.length === 0) {
        // reset any data collected during parsing
        predicates = [];
        // and break the loop
        break;
      }

      predicates.push((0, _condition2.default)((0, _and2.default)(expressions), _treatments2.default.parse(partitions), label, conditionType));
    }

    // Instanciate evaluator given the set of conditions using if else if logic
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return (0, _ifelseif2.default)(predicates);
}

exports.default = parse;
module.exports = exports.default;