'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _types = require('../matchers/types');

var _segment = require('./segment');

var _segment2 = _interopRequireDefault(_segment);

var _whitelist = require('./whitelist');

var _whitelist2 = _interopRequireDefault(_whitelist);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Flat the complex matcherGroup structure into something handy.
 */
function transform(matcherGroup) {
  var _matcherGroup$matcher = matcherGroup.matchers[0],
      matcherType = _matcherGroup$matcher.matcherType,
      segmentObject = _matcherGroup$matcher.userDefinedSegmentMatcherData,
      whitelistObject = _matcherGroup$matcher.whitelistMatcherData;


  var type = (0, _types.mapper)(matcherType);
  var value = undefined;

  if (type === _types.types.SEGMENT) {
    value = (0, _segment2.default)(segmentObject);
  } else if (type === _types.types.WHITELIST) {
    value = (0, _whitelist2.default)(whitelistObject);
  }

  return {
    type: type,
    value: value
  };
} /**
  Copyright 2016 Split Software
  
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
      http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  **/
exports.default = transform;
module.exports = exports.default;