'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lang = require('../../utils/lang');

var _types = require('../matchers/types');

var _segment = require('./segment');

var _segment2 = _interopRequireDefault(_segment);

var _whitelist = require('./whitelist');

var _whitelist2 = _interopRequireDefault(_whitelist);

var _set = require('./set');

var _set2 = _interopRequireDefault(_set);

var _unaryNumeric = require('./unaryNumeric');

var _unaryNumeric2 = _interopRequireDefault(_unaryNumeric);

var _convertions = require('../convertions');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Flat the complex matcherGroup structure into something handy.
function transform(matchers) {

  var parsedMatchers = matchers.map(function (matcher) {
    var matcherType = matcher.matcherType,
        negate = matcher.negate,
        keySelector = matcher.keySelector,
        segmentObject = matcher.userDefinedSegmentMatcherData,
        whitelistObject = matcher.whitelistMatcherData,
        unaryNumericObject = matcher.unaryNumericMatcherData,
        betweenObject = matcher.betweenMatcherData,
        dependencyObject = matcher.dependencyMatcherData,
        booleanMatcherData = matcher.booleanMatcherData,
        stringMatcherData = matcher.stringMatcherData;


    var attribute = keySelector && keySelector.attribute;
    var type = (0, _types.mapper)(matcherType);
    // As default input data type we use string (even for ALL_KEYS)
    var dataType = _types.dataTypes.STRING;
    var value = undefined;

    if (type === _types.types.SEGMENT) {
      value = (0, _segment2.default)(segmentObject);
    } else if (type === _types.types.WHITELIST) {
      value = (0, _whitelist2.default)(whitelistObject);
    } else if (type === _types.types.EQUAL_TO) {
      value = (0, _unaryNumeric2.default)(unaryNumericObject);
      dataType = _types.dataTypes.NUMBER;

      if (unaryNumericObject.dataType === 'DATETIME') {
        value = (0, _convertions.zeroSinceHH)(value);
        dataType = _types.dataTypes.DATETIME;
      }
    } else if (type === _types.types.GREATER_THAN_OR_EQUAL_TO || type === _types.types.LESS_THAN_OR_EQUAL_TO) {
      value = (0, _unaryNumeric2.default)(unaryNumericObject);
      dataType = _types.dataTypes.NUMBER;

      if (unaryNumericObject.dataType === 'DATETIME') {
        value = (0, _convertions.zeroSinceSS)(value);
        dataType = _types.dataTypes.DATETIME;
      }
    } else if (type === _types.types.BETWEEN) {
      value = betweenObject;
      dataType = _types.dataTypes.NUMBER;

      if (betweenObject.dataType === 'DATETIME') {
        value.start = (0, _convertions.zeroSinceSS)(value.start);
        value.end = (0, _convertions.zeroSinceSS)(value.end);
        dataType = _types.dataTypes.DATETIME;
      }
    } else if (type === _types.types.EQUAL_TO_SET || type === _types.types.CONTAINS_ANY_OF_SET || type === _types.types.CONTAINS_ALL_OF_SET || type === _types.types.PART_OF_SET) {
      value = (0, _set2.default)(whitelistObject);
      dataType = _types.dataTypes.SET;
    } else if (type === _types.types.STARTS_WITH || type === _types.types.ENDS_WITH || type === _types.types.CONTAINS_STRING) {
      value = (0, _set2.default)(whitelistObject);
    } else if (type === _types.types.IN_SPLIT_TREATMENT) {
      value = dependencyObject;
      dataType = _types.dataTypes.NOT_SPECIFIED;
    } else if (type === _types.types.EQUAL_TO_BOOLEAN) {
      dataType = _types.dataTypes.BOOLEAN;
      value = booleanMatcherData;
    } else if (type === _types.types.MATCHES_STRING) {
      value = stringMatcherData;
    }

    return {
      attribute: attribute, // attribute over we should do the matching, undefined means 'use the key'
      negate: negate, // should we negate the result?
      type: type, // which kind of matcher we should evaluate
      value: value, // metadata used for the matching
      dataType: dataType // runtime input data type
    };
  });

  if ((0, _lang.findIndex)(parsedMatchers, function (m) {
    return m.type === _types.types.UNDEFINED;
  }) === -1) {
    return parsedMatchers;
  } else {
    return [];
  }
} /**
  Copyright 2016 Split Software
  
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
      http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  **/

exports.default = transform;
module.exports = exports.default;