'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _timeTracker = require('../utils/timeTracker');

var _timeTracker2 = _interopRequireDefault(_timeTracker);

var _repeat = require('../utils/fn/repeat');

var _repeat2 = _interopRequireDefault(_repeat);

var _events = require('../services/events');

var _events2 = _interopRequireDefault(_events);

var _bulk = require('../services/events/bulk');

var _bulk2 = _interopRequireDefault(_bulk);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-events');


var EventsFactory = function EventsFactory(context) {
  var settings = context.get(context.constants.SETTINGS);
  var storage = context.get(context.constants.STORAGE);

  var pushEvents = function pushEvents() {
    if (storage.events.isEmpty()) return _promise2.default.resolve();

    log.info('Pushing ' + storage.events.state().length + ' queued events.');
    var latencyTrackerStop = _timeTracker2.default.start(_timeTracker2.default.TaskNames.EVENTS_PUSH);
    var json = (0, _stringify2.default)(storage.events.toJSON());
    var wrapUpCb = function wrapUpCb() {
      return latencyTrackerStop();
    };
    storage.events.clear(); // we always clear the queue.

    return (0, _events2.default)((0, _bulk2.default)(settings, {
      data: json
    })).then(wrapUpCb).catch(wrapUpCb);
  };

  var stopEventPublisherTimeout = false;
  var stopEventsPublisher = false;
  var startEventsPublisher = function startEventsPublisher() {
    return stopEventsPublisher = (0, _repeat2.default)(function (schedulePublisher) {
      return pushEvents().then(function () {
        return schedulePublisher();
      });
    }, settings.scheduler.eventsPushRate);
  };

  return {
    start: function start() {
      // On the browser there may be a wish to wait an specific amount of seconds before the first push.
      if (settings.startup.eventsFirstPushWindow > 0) {
        stopEventPublisherTimeout = setTimeout(startEventsPublisher, settings.startup.eventsFirstPushWindow);
      } else {
        startEventsPublisher();
      }
    },
    flush: function flush() {
      return pushEvents();
    },
    stop: function stop() {
      stopEventPublisherTimeout && clearTimeout(stopEventPublisherTimeout);
      stopEventsPublisher && stopEventsPublisher();
    },
    flushAndResetTimer: function flushAndResetTimer() {
      // Reset the timer and push the events.
      log.info('Flushing events and reseting timer.');
      stopEventsPublisher && stopEventsPublisher.reset();
      return pushEvents();
    }
  };
};

exports.default = EventsFactory;
module.exports = exports.default;