'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _create = require('babel-runtime/core-js/object/create');

var _create2 = _interopRequireDefault(_create);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _client = require('../client');

var _client2 = _interopRequireDefault(_client);

var _offline = require('../producer/offline');

var _offline2 = _interopRequireDefault(_offline);

var _inputValidation = require('../utils/inputValidation');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//
// Create SDK instance for offline mode.
//
function SplitFactoryOffline(context, sharedTrackers) {
  var sharedInstance = !sharedTrackers;
  var readiness = context.get(context.constants.READINESS);
  var storage = context.get(context.constants.STORAGE);
  var statusManager = context.get(context.constants.STATUS_MANAGER);

  // Producer
  var producer = sharedInstance ? undefined : (0, _offline2.default)(context);

  // Start background task for flag updates
  producer && producer.start();

  var api = (0, _assign2.default)(
  // Proto linkage of the EventEmitter to prevent any change
  (0, _create2.default)(statusManager),
  // GetTreatment/s
  (0, _client2.default)(context),
  // Utilities
  {
    // Destroy instance. Async so we respect the online api.
    destroy: function () {
      var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
        return _regenerator2.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Stop background jobs
                producer && producer.stop();
                // Cleanup event listeners
                readiness.destroy();
                // Cleanup storage
                storage.destroy && storage.destroy();
                // Mark the factory as destroyed.
                context.put(context.constants.DESTROYED, true);
                !sharedInstance && (0, _inputValidation.releaseApiKey)();

              case 5:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function destroy() {
        return _ref.apply(this, arguments);
      }

      return destroy;
    }()
  });

  return {
    api: api,
    metricCollectors: false // We won't collect any metrics on localhost mode.
  };
}

exports.default = SplitFactoryOffline;
module.exports = exports.default;