'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _create = require('babel-runtime/core-js/object/create');

var _create2 = _interopRequireDefault(_create);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _client = require('../client');

var _client2 = _interopRequireDefault(_client);

var _producer = require('../producer');

var _producer2 = _interopRequireDefault(_producer);

var _Partial = require('../producer/browser/Partial');

var _Partial2 = _interopRequireDefault(_Partial);

var _metrics = require('../metrics');

var _metrics2 = _interopRequireDefault(_metrics);

var _events = require('../events');

var _events2 = _interopRequireDefault(_events);

var _listeners = require('../listeners');

var _listeners2 = _interopRequireDefault(_listeners);

var _constants = require('../utils/constants');

var _inputValidation = require('../utils/inputValidation');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

//
// Create SDK instance based on the provided configurations
//
function SplitFactoryOnline(context, readyTrackers, mainClientMetricCollectors) {
  var sharedInstance = !!mainClientMetricCollectors;
  var settings = context.get(context.constants.SETTINGS);
  var readiness = context.get(context.constants.READINESS);
  var storage = context.get(context.constants.STORAGE);
  var statusManager = context.get(context.constants.STATUS_MANAGER);

  // We are only interested in exposable EventEmitter
  var gate = readiness.gate,
      splits = readiness.splits,
      segments = readiness.segments;

  // Events name

  var SDK_READY = gate.SDK_READY;

  // Shared instances use parent metrics collectors

  var metrics = sharedInstance ? undefined : (0, _metrics2.default)(context);
  // Shared instances use parent events queue
  var events = sharedInstance ? undefined : (0, _events2.default)(context);
  // Signal listener only needed for main instances
  var signalsListener = sharedInstance ? undefined : new _listeners2.default(context);

  var producer = void 0;

  switch (settings.mode) {
    case _constants.PRODUCER_MODE:
    case _constants.STANDALONE_MODE:
      {
        context.put(context.constants.COLLECTORS, metrics && metrics.collectors);
        // We don't fully instantiate producer if we are creating a shared instance.
        producer = sharedInstance ? (0, _Partial2.default)(context) : (0, _producer2.default)(context);
        break;
      }
    case _constants.CONSUMER_MODE:
      {
        context.put(context.constants.READY, true); // For SDK inner workings it's supposed to be ready.
        setTimeout(function () {
          // Allow for the sync statements to run so client is returned before these are emitted and callbacks executed.
          splits.emit(splits.SDK_SPLITS_ARRIVED, false);
          segments.emit(segments.SDK_SEGMENTS_ARRIVED, false);
        }, 0);
        break;
      }
  }

  if (readyTrackers && producer && !sharedInstance) {
    // Only track ready events for non-shared and non-consumer clients
    var sdkReadyTracker = readyTrackers.sdkReadyTracker,
        splitsReadyTracker = readyTrackers.splitsReadyTracker,
        segmentsReadyTracker = readyTrackers.segmentsReadyTracker;

    // Defered setup of collectors for this task, as it is the only ready latency we store on BE.

    sdkReadyTracker.setCollectorForTask(metrics.collectors);

    gate.on(SDK_READY, sdkReadyTracker);
    splits.once(splits.SDK_SPLITS_ARRIVED, splitsReadyTracker);
    segments.once(segments.SDK_SEGMENTS_ARRIVED, segmentsReadyTracker);
  }

  // Start background jobs tasks
  producer && producer.start();
  metrics && metrics.start();
  events && context.put(context.constants.EVENTS, events) && events.start();

  // If no collectors are stored we are on a shared instance, save main one.
  context.put(context.constants.COLLECTORS, mainClientMetricCollectors);

  var api = (0, _assign2.default)(
  // Proto linkage of the EventEmitter to prevent any change
  (0, _create2.default)(statusManager),
  // getTreatment/s & track
  (0, _client2.default)(context),
  // Utilities
  {
    // Destroy instance
    destroy: function () {
      var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
        return _regenerator2.default.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Stop background jobs
                producer && producer.stop();
                metrics && metrics.stop();
                events && events.stop();

                // Send impressions and events in parallel.
                _context.next = 5;
                return _promise2.default.all([metrics && metrics.flush(), events && events.flush()]);

              case 5:

                // Cleanup event listeners
                readiness.destroy();
                signalsListener && signalsListener.stop();

                // Cleanup storage
                storage.destroy && storage.destroy();
                // Mark the factory as destroyed.
                context.put(context.constants.DESTROYED, true);
                // And release the API Key
                !sharedInstance && (0, _inputValidation.releaseApiKey)(settings.core.authorizationKey);

              case 10:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function destroy() {
        return _ref.apply(this, arguments);
      }

      return destroy;
    }()
  });

  // We'll start the signals listener if the client is not a shared instance.
  // For now, we will only call destroy.
  !sharedInstance && signalsListener.start(api.destroy);

  return {
    api: api,
    metricCollectors: metrics && metrics.collectors
  };
}

exports.default = SplitFactoryOnline;
module.exports = exports.default;