'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _thenable = require('../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-client:cleanup');

/**
 * We'll listen for SIGTERM since it's the standard signal for server shutdown.
 *
 * If you're stopping the execution yourself via the keyboard, or by calling process.exit,
 * you should call the cleanup logic yourself, since we cannot ensure the data is sent after
 * the process is already exiting.
 */

var NodeSignalListener = function () {
  function NodeSignalListener() {
    (0, _classCallCheck3.default)(this, NodeSignalListener);

    this._sigtermHandler = this._sigtermHandler.bind(this);
  }

  (0, _createClass3.default)(NodeSignalListener, [{
    key: 'start',
    value: function start(handler) {
      this.handler = handler;

      log.debug('Registering cleanup handlers.');
      process.on('SIGTERM', this._sigtermHandler);
    }
  }, {
    key: 'stop',
    value: function stop() {
      log.debug('Deregistering cleanup handlers.');
      process.removeListener('SIGTERM', this._sigtermHandler);
    }

    /**
     * Call the handler, clean up listeners and emit the signal again.
     */

  }, {
    key: '_sigtermHandler',
    value: function _sigtermHandler() {
      var _this = this;

      var wrapUp = function wrapUp() {
        // Cleaned up, remove handlers.
        _this.stop();

        // This handler prevented the default behaviour, start again.
        process.kill(process.pid, 'SIGTERM');
      };

      log.debug('Split SDK graceful shutdown after SIGTERM.');

      var handlerResult = null;

      try {
        handlerResult = this.handler();
      } catch (err) {
        log.error('Error with Split graceful shutdown: ' + err);
      }

      if ((0, _thenable2.default)(handlerResult)) {
        // Always exit, even with errors. The promise is returned for UT purposses.
        return handlerResult.then(wrapUp).catch(wrapUp);
      } else {
        wrapUp();
      }
    }
  }]);
  return NodeSignalListener;
}();

exports.default = NodeSignalListener;
module.exports = exports.default;