'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _create = require('babel-runtime/core-js/object/create');

var _create2 = _interopRequireDefault(_create);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _thenable = require('../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

var _lang = require('../utils/lang');

var _inputValidation = require('../utils/inputValidation');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var collectTreatments = function collectTreatments(splitObject) {
  var conditions = splitObject.conditions;
  // Rollout conditions are supposed to have the entire partitions list, so we find the first one.
  var allTreatmentsCondition = (0, _lang.find)(conditions, function (cond) {
    return cond.conditionType === 'ROLLOUT';
  });
  // Localstorage mode could fall into a no rollout conditions state. Take the first condition in that case.
  if (!allTreatmentsCondition) allTreatmentsCondition = conditions[0];
  // Then extract the treatments from the partitions
  return allTreatmentsCondition ? allTreatmentsCondition.partitions.map(function (v) {
    return v.treatment;
  }) : [];
};

var ObjectToView = function ObjectToView(json) {
  var splitObject = void 0;

  try {
    splitObject = JSON.parse(json);
  } catch (e) {
    return null;
  }

  if (splitObject == null) return null;

  return {
    name: splitObject.name,
    trafficType: splitObject.trafficTypeName || null,
    killed: splitObject.killed,
    changeNumber: splitObject.changeNumber || 0,
    treatments: collectTreatments(splitObject),
    configs: splitObject.configurations || {}
  };
};

var ObjectsToViews = function ObjectsToViews(jsons) {
  var views = [];

  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = (0, _getIterator3.default)(jsons), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var split = _step.value;

      var view = ObjectToView(split);
      if (view != null) views.push(view);
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }

  return views;
};

var SplitManagerFactory = function SplitManagerFactory(_splits, context) {
  var SPLIT_FN_LABEL = 'split';
  var statusManager = context.get(context.constants.STATUS_MANAGER);

  return (0, _assign2.default)(
  // Proto-linkage of the readiness Event Emitter
  (0, _create2.default)(statusManager), {
    /**
     * Get the Split object corresponding to the given split name if valid
     */
    split: function split(maybeSplitName) {
      var splitName = (0, _inputValidation.validateSplit)(maybeSplitName, SPLIT_FN_LABEL);
      if (!(0, _inputValidation.validateIfDestroyed)(context) || !(0, _inputValidation.validateIfReady)(context, SPLIT_FN_LABEL) || !splitName) {
        return null;
      }

      var split = _splits.getSplit(splitName);

      if ((0, _thenable2.default)(split)) {
        return split.then(function (result) {
          (0, _inputValidation.validateSplitExistance)(context, splitName, result, SPLIT_FN_LABEL);
          return ObjectToView(result);
        });
      }

      (0, _inputValidation.validateSplitExistance)(context, splitName, split, SPLIT_FN_LABEL);

      return ObjectToView(split);
    },

    /**
     * Get the Split objects present on the factory storage
     */
    splits: function splits() {
      if (!(0, _inputValidation.validateIfDestroyed)(context) || !(0, _inputValidation.validateIfReady)(context, 'splits')) {
        return [];
      }
      var currentSplits = _splits.getAll();

      if ((0, _thenable2.default)(currentSplits)) return currentSplits.then(ObjectsToViews);
      return ObjectsToViews(currentSplits);
    },

    /**
     * Get the Split names present on the factory storage
     */
    names: function names() {
      if (!(0, _inputValidation.validateIfDestroyed)(context) || !(0, _inputValidation.validateIfReady)(context, 'names')) {
        return [];
      }
      return _splits.getKeys();
    }
  });
};

exports.default = SplitManagerFactory;
module.exports = exports.default;