'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClientCollector = exports.MySegmentsCollector = exports.SplitChangesCollector = exports.SegmentChangesCollector = undefined;

var _getPrototypeOf = require('babel-runtime/core-js/object/get-prototype-of');

var _getPrototypeOf2 = _interopRequireDefault(_getPrototypeOf);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var ProducerMetricsCollector = function () {
  function ProducerMetricsCollector(storage) {
    (0, _classCallCheck3.default)(this, ProducerMetricsCollector);

    this.storage = storage;

    this.latency = this.latency.bind(this);
    this.count = this.count.bind(this);
    this.countException = this.countException.bind(this);
  }

  (0, _createClass3.default)(ProducerMetricsCollector, [{
    key: 'latency',
    value: function latency(ms) {
      this.storage.metrics.track(this.metricType + '.time', ms);
    }
  }, {
    key: 'count',
    value: function count(status) {
      this.storage.count.track(this.metricType + '.status.' + status);
    }
  }, {
    key: 'countException',
    value: function countException() {
      this.storage.count.track(this.metricType + '.exception');
    }
  }]);
  return ProducerMetricsCollector;
}();

var SegmentChangesCollector = exports.SegmentChangesCollector = function (_ProducerMetricsColle) {
  (0, _inherits3.default)(SegmentChangesCollector, _ProducerMetricsColle);

  function SegmentChangesCollector(storage) {
    (0, _classCallCheck3.default)(this, SegmentChangesCollector);

    var _this = (0, _possibleConstructorReturn3.default)(this, (SegmentChangesCollector.__proto__ || (0, _getPrototypeOf2.default)(SegmentChangesCollector)).call(this, storage));

    _this.metricType = 'segmentChangeFetcher';
    return _this;
  }

  return SegmentChangesCollector;
}(ProducerMetricsCollector);

var SplitChangesCollector = exports.SplitChangesCollector = function (_ProducerMetricsColle2) {
  (0, _inherits3.default)(SplitChangesCollector, _ProducerMetricsColle2);

  function SplitChangesCollector(storage) {
    (0, _classCallCheck3.default)(this, SplitChangesCollector);

    var _this2 = (0, _possibleConstructorReturn3.default)(this, (SplitChangesCollector.__proto__ || (0, _getPrototypeOf2.default)(SplitChangesCollector)).call(this, storage));

    _this2.metricType = 'splitChangeFetcher';
    return _this2;
  }

  return SplitChangesCollector;
}(ProducerMetricsCollector);

var MySegmentsCollector = exports.MySegmentsCollector = function (_ProducerMetricsColle3) {
  (0, _inherits3.default)(MySegmentsCollector, _ProducerMetricsColle3);

  function MySegmentsCollector(storage) {
    (0, _classCallCheck3.default)(this, MySegmentsCollector);

    var _this3 = (0, _possibleConstructorReturn3.default)(this, (MySegmentsCollector.__proto__ || (0, _getPrototypeOf2.default)(MySegmentsCollector)).call(this, storage));

    _this3.metricType = 'mySegmentsFetcher';
    return _this3;
  }

  return MySegmentsCollector;
}(ProducerMetricsCollector);

var ClientCollector = exports.ClientCollector = function () {
  function ClientCollector(storage) {
    (0, _classCallCheck3.default)(this, ClientCollector);

    this.storage = storage;

    this.ready = this.ready.bind(this);
    this.getTreatment = this.getTreatment.bind(this);
    this.getTreatments = this.getTreatments.bind(this);
    this.getTreatmentWithConfig = this.getTreatmentWithConfig.bind(this);
    this.getTreatmentsWithConfig = this.getTreatmentsWithConfig.bind(this);
  }

  (0, _createClass3.default)(ClientCollector, [{
    key: 'ready',
    value: function ready(ms) {
      this.storage.metrics.track('sdk.ready', ms);
    }
  }, {
    key: 'getTreatment',
    value: function getTreatment(ms) {
      this.storage.metrics.track('sdk.getTreatment', ms);
    }
  }, {
    key: 'getTreatments',
    value: function getTreatments(ms) {
      this.storage.metrics.track('sdk.getTreatments', ms);
    }
  }, {
    key: 'getTreatmentWithConfig',
    value: function getTreatmentWithConfig(ms) {
      this.storage.metrics.track('sdk.getTreatmentWithConfig', ms);
    }
  }, {
    key: 'getTreatmentsWithConfig',
    value: function getTreatmentsWithConfig(ms) {
      this.storage.metrics.track('sdk.getTreatmentsWithConfig', ms);
    }
  }]);
  return ClientCollector;
}();