'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _timeTracker = require('../utils/timeTracker');

var _timeTracker2 = _interopRequireDefault(_timeTracker);

var _repeat = require('../utils/fn/repeat');

var _repeat2 = _interopRequireDefault(_repeat);

var _metrics = require('../services/metrics');

var _metrics2 = _interopRequireDefault(_metrics);

var _times = require('../services/metrics/times');

var _times2 = _interopRequireDefault(_times);

var _counters = require('../services/metrics/counters');

var _counters2 = _interopRequireDefault(_counters);

var _dto = require('../services/metrics/dto');

var _impressions = require('../services/impressions');

var _impressions2 = _interopRequireDefault(_impressions);

var _bulk = require('../services/impressions/bulk');

var _bulk2 = _interopRequireDefault(_bulk);

var _dto2 = require('../services/impressions/dto');

var _Collectors = require('./Collectors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-metrics'); /**
                                                    Copyright 2016 Split Software
                                                    
                                                    Licensed under the Apache License, Version 2.0 (the "License");
                                                    you may not use this file except in compliance with the License.
                                                    You may obtain a copy of the License at
                                                    
                                                        http://www.apache.org/licenses/LICENSE-2.0
                                                    
                                                    Unless required by applicable law or agreed to in writing, software
                                                    distributed under the License is distributed on an "AS IS" BASIS,
                                                    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                    See the License for the specific language governing permissions and
                                                    limitations under the License.
                                                    **/

var MetricsFactory = function MetricsFactory(context) {
  var impressionsRetries = 0;
  var settings = context.get(context.constants.SETTINGS);
  var storage = context.get(context.constants.STORAGE);

  var pushMetrics = function pushMetrics() {
    if (storage.metrics.isEmpty() && storage.count.isEmpty()) return _promise2.default.resolve();

    log.info('Pushing metrics');
    var latencyTrackerStop = _timeTracker2.default.start(_timeTracker2.default.TaskNames.METRICS_PUSH);

    // POST latencies
    var latenciesPromise = storage.metrics.isEmpty() ? null : (0, _metrics2.default)((0, _times2.default)(settings, {
      data: (0, _stringify2.default)((0, _dto.fromLatenciesCollector)(storage.metrics))
    })).then(function () {
      return storage.metrics.clear();
    }).catch(function () {
      return storage.metrics.clear();
    });

    // POST counters
    var countersPromise = storage.count.isEmpty() ? null : (0, _metrics2.default)((0, _counters2.default)(settings, {
      data: (0, _stringify2.default)((0, _dto.fromCountersCollector)(storage.count))
    })).then(function () {
      return storage.count.clear();
    }).catch(function () {
      return storage.count.clear();
    });

    return _promise2.default.all([latenciesPromise, countersPromise]).then(function (resp) {
      // After both finishes, track the end and return the results
      latencyTrackerStop();
      return resp;
    });
  };

  var pushImpressions = function pushImpressions() {
    if (storage.impressions.isEmpty()) return _promise2.default.resolve();
    var imprCount = storage.impressions.queue.length;

    log.info('Pushing ' + imprCount + ' impressions');
    var latencyTrackerStop = _timeTracker2.default.start(_timeTracker2.default.TaskNames.IMPRESSIONS_PUSH);

    return (0, _impressions2.default)((0, _bulk2.default)(settings, {
      data: (0, _stringify2.default)((0, _dto2.fromImpressionsCollector)(storage.impressions, settings))
    })).then(function () {
      impressionsRetries = 0;
      storage.impressions.clear();
    }).catch(function (err) {
      if (impressionsRetries) {
        // For now we retry only once.
        log.warn('Droping ' + imprCount + ' impressions after retry. Reason ' + err + '.');
        impressionsRetries = 0;
        storage.impressions.clear();
      } else {
        impressionsRetries++;
        log.warn('Failed to push ' + imprCount + ' impressions, keeping data to retry on next iteration. Reason ' + err + '.');
      }
    }).then(function () {
      return latencyTrackerStop();
    });
  };

  var stopImpressionsPublisher = false;
  var stopPerformancePublisher = false;

  return {
    start: function start() {
      stopImpressionsPublisher = (0, _repeat2.default)(function (schedulePublisher) {
        return pushImpressions().then(function () {
          return schedulePublisher();
        });
      }, settings.scheduler.impressionsRefreshRate);

      stopPerformancePublisher = (0, _repeat2.default)(function (schedulePublisher) {
        return pushMetrics().then(function () {
          return schedulePublisher();
        });
      }, settings.scheduler.metricsRefreshRate);
    },
    flush: function flush() {
      return pushImpressions();
    },
    stop: function stop() {
      stopImpressionsPublisher && stopImpressionsPublisher();
      stopPerformancePublisher && stopPerformancePublisher();
    },


    // Metrics collectors
    collectors: {
      segmentChanges: new _Collectors.SegmentChangesCollector(storage),
      splitChanges: new _Collectors.SplitChangesCollector(storage),
      mySegments: new _Collectors.MySegmentsCollector(storage),
      client: new _Collectors.ClientCollector(storage)
    }
  };
};

exports.default = MetricsFactory;
module.exports = exports.default;