'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _task = require('../task');

var _task2 = _interopRequireDefault(_task);

var _SplitChanges = require('../updater/SplitChanges');

var _SplitChanges2 = _interopRequireDefault(_SplitChanges);

var _MySegments = require('../updater/MySegments');

var _MySegments2 = _interopRequireDefault(_MySegments);

var _onSplitsArrivedFactory = require('./onSplitsArrivedFactory');

var _onSplitsArrivedFactory2 = _interopRequireDefault(_onSplitsArrivedFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-producer:updater');

/**
 * Startup all the background jobs required for a Browser SDK instance.
 */
/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var FullBrowserProducer = function FullBrowserProducer(context) {
  var splitsUpdater = (0, _SplitChanges2.default)(context);
  var segmentsUpdater = (0, _MySegments2.default)(context);

  var settings = context.get(context.constants.SETTINGS);

  var _context$get = context.get(context.constants.READINESS),
      splitsEventEmitter = _context$get.splits;

  var splitsUpdaterTask = (0, _task2.default)(splitsUpdater, settings.scheduler.featuresRefreshRate);
  var segmentsUpdaterTask = (0, _task2.default)(segmentsUpdater, settings.scheduler.segmentsRefreshRate);

  var onSplitsArrived = (0, _onSplitsArrivedFactory2.default)(segmentsUpdaterTask, context);

  splitsEventEmitter.on(splitsEventEmitter.SDK_SPLITS_ARRIVED, onSplitsArrived);

  return {
    start: function start() {
      log.info('Starting BROWSER producer');

      splitsUpdaterTask.start();
      segmentsUpdaterTask.start();
    },
    stop: function stop() {
      log.info('Stopping BROWSER producer');

      splitsUpdaterTask.stop();
      segmentsUpdaterTask && segmentsUpdaterTask.stop();
    }
  };
};

exports.default = FullBrowserProducer;
module.exports = exports.default;