'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _task = require('../task');

var _task2 = _interopRequireDefault(_task);

var _MySegments = require('../updater/MySegments');

var _MySegments2 = _interopRequireDefault(_MySegments);

var _onSplitsArrivedFactory = require('./onSplitsArrivedFactory');

var _onSplitsArrivedFactory2 = _interopRequireDefault(_onSplitsArrivedFactory);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Incremental updater to be used to share data in the browser.
 */
var PartialBrowserProducer = function PartialBrowserProducer(context) {
  var settings = context.get(context.constants.SETTINGS);

  var _context$get = context.get(context.constants.READINESS),
      splitsEventEmitter = _context$get.splits;

  var segmentsUpdater = (0, _MySegments2.default)(context);
  var segmentsUpdaterTask = (0, _task2.default)(segmentsUpdater, settings.scheduler.segmentsRefreshRate);

  var onSplitsArrived = (0, _onSplitsArrivedFactory2.default)(segmentsUpdaterTask, context);

  splitsEventEmitter.on(splitsEventEmitter.SDK_SPLITS_ARRIVED, onSplitsArrived);

  return segmentsUpdaterTask;
}; /**
   Copyright 2016 Split Software
   
   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at
   
       http://www.apache.org/licenses/LICENSE-2.0
   
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   **/

exports.default = PartialBrowserProducer;
module.exports = exports.default;