'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _timeout = require('../../utils/promise/timeout');

var _timeout2 = _interopRequireDefault(_timeout);

var _timeTracker = require('../../utils/timeTracker');

var _timeTracker2 = _interopRequireDefault(_timeTracker);

var _mySegments = require('../../services/mySegments');

var _mySegments2 = _interopRequireDefault(_mySegments);

var _get = require('../../services/mySegments/get');

var _get2 = _interopRequireDefault(_get);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var mySegmentsFetcher = function mySegmentsFetcher(settings) {
  var startingUp = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var metricCollectors = arguments[2];

  var mySegmentsPromise = (0, _mySegments2.default)((0, _get2.default)(settings));

  mySegmentsPromise = _timeTracker2.default.start(_timeTracker2.default.TaskNames.MY_SEGMENTS_FETCH, startingUp ? metricCollectors : false, mySegmentsPromise);

  // Decorate with the timeout functionality if required
  if (startingUp) {
    mySegmentsPromise = (0, _timeout2.default)(settings.startup.requestTimeoutBeforeReady, mySegmentsPromise);
  }

  // Extract segment names
  return mySegmentsPromise.then(function (resp) {
    return resp.data;
  }).then(function (json) {
    return json.mySegments.map(function (segment) {
      return segment.name;
    });
  });
};

exports.default = mySegmentsFetcher;
module.exports = exports.default;