'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _segmentChanges = require('../../services/segmentChanges');

var _segmentChanges2 = _interopRequireDefault(_segmentChanges);

var _get = require('../../services/segmentChanges/get');

var _get2 = _interopRequireDefault(_get);

var _timeTracker = require('../../utils/timeTracker');

var _timeTracker2 = _interopRequireDefault(_timeTracker);

var _lang = require('../../utils/lang');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

function greedyFetch(settings, lastSinceValue, segmentName, metricCollectors) {
  return _timeTracker2.default.start(_timeTracker2.default.TaskNames.SEGMENTS_FETCH, metricCollectors, (0, _segmentChanges2.default)((0, _get2.default)(settings, {
    since: lastSinceValue,
    segmentName: segmentName
  }))).then(function (resp) {
    return resp.data;
  }).then(function (json) {
    var since = json.since,
        till = json.till;

    if (since === till) {
      return [json];
    } else {
      return _promise2.default.all([json, greedyFetch(settings, till, segmentName)]).then(function (flatMe) {
        return [flatMe[0]].concat((0, _toConsumableArray3.default)(flatMe[1]));
      });
    }
  }).catch(function (err) {
    // If the operation is forbidden it may be due to permissions, don't recover and propagate the error.
    if ((0, _lang.startsWith)(err.message, '403')) throw err;
    // if something goes wrong with the request to the server, we are going to
    // stop requesting information till the next round of downloading
    return [];
  });
}

// @TODO migrate to a generator function and do the job incrementally
function segmentChangesFetcher(settings, segmentName, since, metricCollectors) {
  return greedyFetch(settings, since, segmentName, metricCollectors);
}

exports.default = segmentChangesFetcher;
module.exports = exports.default;