'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _timeout = require('../../utils/promise/timeout');

var _timeout2 = _interopRequireDefault(_timeout);

var _timeTracker = require('../../utils/timeTracker');

var _timeTracker2 = _interopRequireDefault(_timeTracker);

var _splitChanges = require('../../services/splitChanges');

var _splitChanges2 = _interopRequireDefault(_splitChanges);

var _get = require('../../services/splitChanges/get');

var _get2 = _interopRequireDefault(_get);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

function splitChangesFetcher(settings, since) {
  var startingUp = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  var metricCollectors = arguments[3];
  var isNode = arguments[4];

  var splitsPromise = (0, _splitChanges2.default)((0, _get2.default)(settings, since));
  var collectMetrics = startingUp || isNode; // If we are on the browser, only collect this metric for first fetch. On node do it always.

  splitsPromise = _timeTracker2.default.start(_timeTracker2.default.TaskNames.SPLITS_FETCH, collectMetrics ? metricCollectors : false, splitsPromise);

  if (startingUp) {
    // Decorate with the timeout functionality if required
    splitsPromise = (0, _timeout2.default)(settings.startup.requestTimeoutBeforeReady, splitsPromise);
  }

  return splitsPromise.then(function (resp) {
    return resp.data;
  });
}

exports.default = splitChangesFetcher;
module.exports = exports.default;