'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _repeat = require('../utils/fn/repeat');

var _repeat2 = _interopRequireDefault(_repeat);

var _SplitChanges = require('./updater/SplitChanges');

var _SplitChanges2 = _interopRequireDefault(_SplitChanges);

var _SegmentChanges = require('./updater/SegmentChanges');

var _SegmentChanges2 = _interopRequireDefault(_SegmentChanges);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-producer:updater'); /**
                                                             Copyright 2016 Split Software
                                                             
                                                             Licensed under the Apache License, Version 2.0 (the "License");
                                                             you may not use this file except in compliance with the License.
                                                             You may obtain a copy of the License at
                                                             
                                                                 http://www.apache.org/licenses/LICENSE-2.0
                                                             
                                                             Unless required by applicable law or agreed to in writing, software
                                                             distributed under the License is distributed on an "AS IS" BASIS,
                                                             WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                             See the License for the specific language governing permissions and
                                                             limitations under the License.
                                                             **/

/**
 * Expose start / stop mechanism for pulling data from services.
 */
var NodeUpdater = function NodeUpdater(context) {
  var splitsUpdater = (0, _SplitChanges2.default)(context, true /* tell split updater we are in node */);
  var segmentsUpdater = (0, _SegmentChanges2.default)(context);
  var settings = context.get(context.constants.SETTINGS);

  var stopSplitsUpdate = false;
  var stopSegmentsUpdate = false;
  var splitFetchCompleted = false;

  return {
    start: function start() {
      log.info('Starting NODEJS updater');
      log.debug('Splits will be refreshed each ' + settings.scheduler.featuresRefreshRate + ' millis');
      log.debug('Segments will be refreshed each ' + settings.scheduler.segmentsRefreshRate + ' millis');

      // Schedule incremental update of segments only if needed
      var spinUpSegmentUpdater = function spinUpSegmentUpdater() {
        if (!stopSegmentsUpdate) {
          stopSegmentsUpdate = (0, _repeat2.default)(function (scheduleSegmentsUpdate) {
            if (splitFetchCompleted) {
              log.debug('Fetching segments');
              segmentsUpdater().then(function () {
                return scheduleSegmentsUpdate();
              });
            } else {
              scheduleSegmentsUpdate();
            }
          }, settings.scheduler.segmentsRefreshRate);
        }
      };

      stopSplitsUpdate = (0, _repeat2.default)(function (scheduleSplitsUpdate) {
        log.debug('Fetching splits');

        splitsUpdater().then(function () {
          // Mark splits as ready (track first successfull call to start downloading segments)
          splitFetchCompleted = true;
          // Spin up the segments update if needed
          spinUpSegmentUpdater();
          // Re-schedule update
          scheduleSplitsUpdate();
        });
      }, settings.scheduler.featuresRefreshRate);
    },
    stop: function stop() {
      log.info('Stopping NODEJS updater');

      stopSplitsUpdate && stopSplitsUpdate();
      stopSegmentsUpdate && stopSegmentsUpdate();
    }
  };
};

exports.default = NodeUpdater;
module.exports = exports.default;