'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _task = require('../task');

var _task2 = _interopRequireDefault(_task);

var _SplitChangesFromFileSystem = require('../updater/SplitChangesFromFileSystem');

var _SplitChangesFromFileSystem2 = _interopRequireDefault(_SplitChangesFromFileSystem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var OfflineFileSystemProducer = function OfflineFileSystemProducer(context) {
  var settings = context.get(context.constants.SETTINGS);
  var updater = (0, _SplitChangesFromFileSystem2.default)(context);
  var updaterTask = (0, _task2.default)(updater, settings.scheduler.offlineRefreshRate);

  return updaterTask;
};

exports.default = OfflineFileSystemProducer;
module.exports = exports.default;