'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _repeat = require('../utils/fn/repeat');

var _repeat2 = _interopRequireDefault(_repeat);

var _lang = require('../utils/lang');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-producer:task'); /**
                                                          Copyright 2016 Split Software
                                                          
                                                          Licensed under the Apache License, Version 2.0 (the "License");
                                                          you may not use this file except in compliance with the License.
                                                          You may obtain a copy of the License at
                                                          
                                                              http://www.apache.org/licenses/LICENSE-2.0
                                                          
                                                          Unless required by applicable law or agreed to in writing, software
                                                          distributed under the License is distributed on an "AS IS" BASIS,
                                                          WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                          See the License for the specific language governing permissions and
                                                          limitations under the License.
                                                          **/

/**
 * Startable task factory.
 */
var TaskFactory = function TaskFactory(updater, period) {
  var updaterName = (0, _lang.getFnName)(updater);
  var stopUpdater = false;

  return {
    start: function start() {
      if (!stopUpdater) {
        log.debug('Starting ' + updaterName + ' refreshing each ' + period);

        stopUpdater = (0, _repeat2.default)(function (reschedule) {
          log.debug('Running ' + updaterName);
          updater().then(function () {
            return reschedule();
          });
        }, period);
      }
    },
    stop: function stop() {
      log.debug('Stopping ' + updaterName);

      stopUpdater && stopUpdater();
      stopUpdater = false;
    }
  };
};

exports.default = TaskFactory;
module.exports = exports.default;