'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _Errors = require('../../utils/lang/Errors');

var _MySegments = require('../fetcher/MySegments');

var _MySegments2 = _interopRequireDefault(_MySegments);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var log = (0, _logger2.default)('splitio-producer:my-segments');


function MySegmentsUpdaterFactory(context) {
  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE],
      metricCollectors = _context$getAll[context.constants.COLLECTORS];

  var segmentsEventEmitter = readiness.segments;

  var readyOnAlreadyExistentState = true;
  var startingUp = true;

  return function MySegmentsUpdater() {
    var retry = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;

    // NOTE: We only collect metrics on startup.
    return (0, _MySegments2.default)(settings, startingUp, metricCollectors).then(function (segments) {
      // Only when we have downloaded segments completely, we should not keep
      // retrying anymore
      startingUp = false;

      // Update the list of segment names available
      var shouldNotifyUpdate = storage.segments.resetSegments(segments);

      // Notify update if required
      if (storage.splits.usesSegments() && (shouldNotifyUpdate || readyOnAlreadyExistentState)) {
        readyOnAlreadyExistentState = false;
        segmentsEventEmitter.emit(segmentsEventEmitter.SDK_SEGMENTS_ARRIVED);
      }
    }).catch(function (error) {
      if (!(error instanceof _Errors.SplitError)) setTimeout(function () {
        throw error;
      }, 0);

      if (startingUp && settings.startup.retriesOnFailureBeforeReady > retry) {
        retry += 1;
        log.warn('Retrying download of segments #' + retry + '. Reason: ' + error);
        return MySegmentsUpdater(retry);
      } else {
        startingUp = false;
      }

      return false; // shouldUpdate = false
    });
  };
}

exports.default = MySegmentsUpdaterFactory;
module.exports = exports.default;