'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _toConsumableArray2 = require('babel-runtime/helpers/toConsumableArray');

var _toConsumableArray3 = _interopRequireDefault(_toConsumableArray2);

var _set = require('babel-runtime/core-js/set');

var _set2 = _interopRequireDefault(_set);

var _getIterator2 = require('babel-runtime/core-js/get-iterator');

var _getIterator3 = _interopRequireDefault(_getIterator2);

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

var _SplitChanges = require('../fetcher/SplitChanges');

var _SplitChanges2 = _interopRequireDefault(_SplitChanges);

var _segments = require('../../engine/parser/segments');

var _segments2 = _interopRequireDefault(_segments);

var _Errors = require('../../utils/lang/Errors');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-producer:split-changes'); /**
                                                                   Copyright 2016 Split Software
                                                                   
                                                                   Licensed under the Apache License, Version 2.0 (the "License");
                                                                   you may not use this file except in compliance with the License.
                                                                   You may obtain a copy of the License at
                                                                   
                                                                       http://www.apache.org/licenses/LICENSE-2.0
                                                                   
                                                                   Unless required by applicable law or agreed to in writing, software
                                                                   distributed under the License is distributed on an "AS IS" BASIS,
                                                                   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                                   See the License for the specific language governing permissions and
                                                                   limitations under the License.
                                                                   **/

function computeSplitsMutation(entries) {
  var computed = entries.reduce(function (accum, split) {
    if (split.status === 'ACTIVE') {
      accum.added.push([split.name, (0, _stringify2.default)(split)]);

      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = (0, _getIterator3.default)((0, _segments2.default)(split.conditions)), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var segmentName = _step.value;

          accum.segments.add(segmentName);
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    } else {
      accum.removed.push(split.name);
    }

    return accum;
  }, {
    added: [],
    removed: [],
    segments: new _set2.default()
  });

  computed.segments = [].concat((0, _toConsumableArray3.default)(computed.segments));

  return computed;
}

function SplitChangesUpdaterFactory(context) {
  var isNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE],
      metricCollectors = _context$getAll[context.constants.COLLECTORS];

  var splitsEventEmitter = readiness.splits;

  var startingUp = true;
  var readyOnAlreadyExistentState = true;

  return function () {
    var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
      var retry = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var since;
      return _regenerator2.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return storage.splits.getChangeNumber();

            case 2:
              since = _context.sent;


              log.debug('Spin up split update using since = ' + since);

              return _context.abrupt('return', (0, _SplitChanges2.default)(settings, since, startingUp, metricCollectors, isNode).then(function (splitChanges) {
                startingUp = false;

                var mutation = computeSplitsMutation(splitChanges.splits);

                log.debug('New splits ' + mutation.added.length);
                log.debug('Removed splits ' + mutation.removed.length);
                log.debug('Segment names collected ' + mutation.segments);

                // Write into storage
                return _promise2.default.all([storage.splits.addSplits(mutation.added), storage.splits.removeSplits(mutation.removed), storage.splits.setChangeNumber(splitChanges.till), storage.segments.registerSegments(mutation.segments)]).then(function () {
                  if (since !== splitChanges.till || readyOnAlreadyExistentState) {
                    readyOnAlreadyExistentState = false;
                    splitsEventEmitter.emit(splitsEventEmitter.SDK_SPLITS_ARRIVED);
                  }
                });
              }).catch(function (error) {
                if (!(error instanceof _Errors.SplitError)) {
                  setTimeout(function () {
                    throw error;
                  }, 0);
                  startingUp = false; // Stop retrying.
                }

                log.warn('Error while doing fetch of Splits ' + error);

                if (startingUp && settings.startup.retriesOnFailureBeforeReady > retry) {
                  retry += 1;
                  log.info('Retrying download of splits #' + retry + '. Reason: ' + error);
                  return SplitChangesUpdater(retry);
                } else {
                  startingUp = false;
                }

                return false;
              }));

            case 5:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function SplitChangesUpdater() {
      return _ref.apply(this, arguments);
    }

    return SplitChangesUpdater;
  }();
}

exports.default = SplitChangesUpdaterFactory;
module.exports = exports.default;