'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _regenerator = require('babel-runtime/regenerator');

var _regenerator2 = _interopRequireDefault(_regenerator);

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _asyncToGenerator2 = require('babel-runtime/helpers/asyncToGenerator');

var _asyncToGenerator3 = _interopRequireDefault(_asyncToGenerator2);

var _lang = require('../../utils/lang');

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/
var log = (0, _logger2.default)('splitio-producer:offline');

function FromObjectUpdaterFactory(Fetcher, context) {
  var _context$getAll = context.getAll(),
      settings = _context$getAll[context.constants.SETTINGS],
      readiness = _context$getAll[context.constants.READINESS],
      storage = _context$getAll[context.constants.STORAGE];

  return function () {
    var _ref = (0, _asyncToGenerator3.default)( /*#__PURE__*/_regenerator2.default.mark(function _callee() {
      var splits, loadError, splitsMock;
      return _regenerator2.default.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              splits = [];
              loadError = null;
              splitsMock = {};

              try {
                splitsMock = Fetcher(settings);
              } catch (err) {
                loadError = err;
                log.error('There was an issue loading the mock Splits data, no changes will be applied to the current cache. ' + err);
              }

              if (loadError) {
                _context.next = 14;
                break;
              }

              log.debug('Splits data:');
              log.debug((0, _stringify2.default)(splitsMock));

              (0, _lang.forOwn)(splitsMock, function (val, name) {
                splits.push([name, (0, _stringify2.default)({
                  name: name,
                  status: 'ACTIVE',
                  killed: false,
                  trafficAllocation: 100,
                  defaultTreatment: 'control',
                  conditions: val.conditions || [],
                  configurations: val.configurations,
                  trafficTypeName: val.trafficTypeName
                })]);
              });

              _context.next = 10;
              return storage.splits.flush();

            case 10:
              _context.next = 12;
              return storage.splits.addSplits(splits);

            case 12:

              readiness.splits.emit(readiness.splits.SDK_SPLITS_ARRIVED);
              readiness.segments.emit(readiness.segments.SDK_SEGMENTS_ARRIVED);

            case 14:
            case 'end':
              return _context.stop();
          }
        }
      }, _callee, this);
    }));

    function ObjectUpdater() {
      return _ref.apply(this, arguments);
    }

    return ObjectUpdater;
  }();
}

exports.default = FromObjectUpdaterFactory;
module.exports = exports.default;