'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _create = require('babel-runtime/core-js/object/create');

var _create2 = _interopRequireDefault(_create);

var _assign = require('babel-runtime/core-js/object/assign');

var _assign2 = _interopRequireDefault(_assign);

var _promise = require('babel-runtime/core-js/promise');

var _promise2 = _interopRequireDefault(_promise);

exports.default = callbackHandlerContext;

var _logger = require('../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('', { displayAllErrors: true });

var NEW_LISTENER_EVENT = 'newListener';
var REMOVE_LISTENER_EVENT = 'removeListener';

function callbackHandlerContext(context) {
  var forSharedClient = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

  var gate = context.get(context.constants.READINESS).gate;
  var readyCbCount = 0;
  var isReady = false;
  var SDK_READY = gate.SDK_READY,
      SDK_UPDATE = gate.SDK_UPDATE,
      SDK_READY_TIMED_OUT = gate.SDK_READY_TIMED_OUT;

  var readyPromise = getReadyPromise();

  gate.once(SDK_READY, function () {
    if (readyCbCount === 0) log.warn('No listeners for SDK Readiness detected. Incorrect control treatments could have been logged if you called getTreatment/s while the SDK was not yet ready.');

    context.put(context.constants.READY, true);

    isReady = true;
  });

  gate.on(REMOVE_LISTENER_EVENT, function (event) {
    if (event === SDK_READY) readyCbCount--;
  });

  gate.on(NEW_LISTENER_EVENT, function (event) {
    if (event === SDK_READY || event === SDK_READY_TIMED_OUT) {
      if (isReady) {
        log.error('A listener was added for ' + (event === SDK_READY ? 'SDK_READY' : 'SDK_READY_TIMED_OUT') + ' on the SDK, which has already fired and won\'t be emitted again. The callback won\'t be executed.');
      } else if (event === SDK_READY) {
        readyCbCount++;
      }
    }
  });

  function generateReadyPromise() {
    var hasCatch = false;
    var promise = new _promise2.default(function (resolve, reject) {
      gate.once(SDK_READY, resolve);
      gate.once(SDK_READY_TIMED_OUT, reject);
    }).catch(function (err) {
      // If the promise has a custom error handler, just propagate
      if (hasCatch) throw err;
      // If not handle the error to prevent unhandled promise exception.
      log.error(err);
    });
    var originalThen = promise.then;

    // Using .catch(fn) is the same than using .then(null, fn)
    promise.then = function () {
      if (arguments.length > 0 && typeof arguments[0] === 'function') readyCbCount++;
      if (arguments.length > 1 && typeof arguments[1] === 'function') hasCatch = true;

      return originalThen.apply(this, arguments);
    };

    return promise;
  }

  function getReadyPromise() {
    if (forSharedClient) {
      return _promise2.default.resolve();
    }

    // Non-shared clients use the full blown ready promise implementation.
    return generateReadyPromise();
  }

  return (0, _assign2.default)(
  // Expose Event Emitter functionality
  (0, _create2.default)(gate), {
    // Expose the event constants without changing the interface
    Event: {
      SDK_READY: SDK_READY,
      SDK_UPDATE: SDK_UPDATE,
      SDK_READY_TIMED_OUT: SDK_READY_TIMED_OUT
    },
    // Expose the ready promise flag
    ready: function ready() {
      return readyPromise;
    }
  });
}
module.exports = exports.default;