'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _options = require('./options');

var _options2 = _interopRequireDefault(_options);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function RequestFactory(settings, relativeUrl, params) {
  var token = settings.core.authorizationKey;
  var version = settings.version;
  var _settings$runtime = settings.runtime,
      ip = _settings$runtime.ip,
      hostname = _settings$runtime.hostname;

  var headers = {};
  var baseline = (0, _options2.default)();

  headers['Accept'] = 'application/json';
  headers['Content-Type'] = 'application/json';
  headers['Authorization'] = 'Bearer ' + token;
  headers['SplitSDKVersion'] = version;

  if (ip) headers['SplitSDKMachineIP'] = ip;
  if (hostname) headers['SplitSDKMachineName'] = hostname;

  return (0, _extends3.default)({
    headers: headers,
    url: settings.url(relativeUrl)
  }, baseline, params);
} /**
  Copyright 2016 Split Software
  
  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at
  
      http://www.apache.org/licenses/LICENSE-2.0
  
  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.
  **/
exports.default = RequestFactory;
module.exports = exports.default;