'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _lang = require('../../../utils/lang');

var _parseCondition = require('./parseCondition');

var _parseCondition2 = _interopRequireDefault(_parseCondition);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function getConfigurationFromSettings(settings) {
  var mockSettings = settings.features || {};
  var splitObjects = {};

  (0, _lang.forOwn)(mockSettings, function (data, splitName) {
    var treatment = data;
    var config = null;

    if ((0, _lang.isObject)(data)) {
      treatment = data.treatment;
      config = data.config || config;
    }
    var configurations = {};
    if (config !== null) configurations[treatment] = config;

    splitObjects[splitName] = {
      conditions: [(0, _parseCondition2.default)({ treatment: treatment })],
      configurations: configurations
    };
  });

  return splitObjects;
}

exports.default = getConfigurationFromSettings;
module.exports = exports.default;