'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = Fetcher;
exports.__getAxiosInstance = __getAxiosInstance;

var _axios = require('axios');

var _axios2 = _interopRequireDefault(_axios);

var _Errors = require('../../utils/lang/Errors');

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-services:service');

var _axiosInstance = _axios2.default.create();

function Fetcher(request) {
  return _axiosInstance.request(request).catch(function (error) {
    var resp = error.response;
    var config = error.config;
    var msg = '';

    if (resp) {
      // An HTTP error
      switch (resp.status) {
        case 404:
          msg = 'Invalid API key or resource not found.';
          break;
        default:
          msg = resp.statusText;
          break;
      }
    } else {
      // Something else, either an error making the request or a Network error.
      msg = error.message;
    }

    if (!resp || resp.status !== 403) // 403's log we'll be handled somewhere else.
      log.error('Response status is not OK. Status: ' + (resp ? resp.status : 'NO_STATUS') + '. URL: ' + config.url + '. Message: ' + msg);

    throw new _Errors.SplitNetworkError(msg, resp ? resp.status : 'NO_STATUS');
  });
}

// This function is only exposed for unit testing purposses.
function __getAxiosInstance() {
  return _axiosInstance;
}