'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _thenable = require('../../utils/promise/thenable');

var _thenable2 = _interopRequireDefault(_thenable);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var MAX_QUEUE_BYTE_SIZE = 5 * 1024 * 1024; // 5M

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var EventsCache = function () {
  function EventsCache(context) {
    var _this = this;

    (0, _classCallCheck3.default)(this, EventsCache);

    var settings = context.get(context.constants.SETTINGS);
    var eventsModule = context.get(context.constants.EVENTS);

    this.onFullQueue = false;
    this.maxQueue = settings.scheduler.eventsQueueSize;
    this.queue = [];
    this.queueByteSize = 0;

    if ((0, _thenable2.default)(eventsModule)) {
      eventsModule.then(function (events) {
        _this.onFullQueue = events.flushAndResetTimer;
        _this._checkForFlush(); // Events is ready, check the queue.
      });
    } else if (typeof eventsModule.flushAndResetTimer === 'function') {
      this.onFullQueue = eventsModule.flushAndResetTimer;
    }
  }

  /**
   * Get the current state of the queue.
   */


  (0, _createClass3.default)(EventsCache, [{
    key: 'state',
    value: function state() {
      return this.queue;
    }

    /**
     * Add a new event object at the end of the queue.
     */

  }, {
    key: 'track',
    value: function track(data) {
      var size = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

      this.queueByteSize += size;
      this.queue.push(data);

      this._checkForFlush();

      return true;
    }

    /**
     * Clear the data stored on the cache.
     */

  }, {
    key: 'clear',
    value: function clear() {
      this.queue = [];
      this.queueByteSize = 0;

      return this;
    }

    /**
     * Returns the payload we will use for posting data.
     */

  }, {
    key: 'toJSON',
    value: function toJSON() {
      return this.queue;
    }

    /**
     * Check if the cache is empty.
     */

  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      return this.queue.length === 0;
    }

    /**
     * Check if the cache queue is full and we need to flush it.
     */

  }, {
    key: '_checkForFlush',
    value: function _checkForFlush() {
      if (this.queueByteSize > MAX_QUEUE_BYTE_SIZE ||
      // 0 means no maximum value, in case we want to avoid this being triggered. Size limit is not affected by it.
      this.maxQueue > 0 && this.queue.length >= this.maxQueue) {
        this.onFullQueue && this.onFullQueue();
      }
    }
  }]);
  return EventsCache;
}();

exports.default = EventsCache;
module.exports = exports.default;