'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = require('babel-runtime/core-js/json/stringify');

var _stringify2 = _interopRequireDefault(_stringify);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _logger = require('../../utils/logger');

var _logger2 = _interopRequireDefault(_logger);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var log = (0, _logger2.default)('splitio-storage:redis'); /**
                                                          Copyright 2016 Split Software
                                                          
                                                          Licensed under the Apache License, Version 2.0 (the "License");
                                                          you may not use this file except in compliance with the License.
                                                          You may obtain a copy of the License at
                                                          
                                                              http://www.apache.org/licenses/LICENSE-2.0
                                                          
                                                          Unless required by applicable law or agreed to in writing, software
                                                          distributed under the License is distributed on an "AS IS" BASIS,
                                                          WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
                                                          See the License for the specific language governing permissions and
                                                          limitations under the License.
                                                          **/

var EventsCache = function () {
  function EventsCache(keys, redis, meta) {
    (0, _classCallCheck3.default)(this, EventsCache);

    this.keys = keys;
    this.redis = redis;
    this.meta = meta;

    this.eventsKey = keys.buildEventsKey();
  }

  /**
   * Add a new event object into the queue.
   */


  (0, _createClass3.default)(EventsCache, [{
    key: 'track',
    value: function track(eventData) {
      return this.redis.rpush(this.eventsKey, this._toJSON(eventData))
      // We use boolean values to signal successful queueing
      .then(function () {
        return true;
      }).catch(function (err) {
        log.error('Error adding event to queue: ' + err + '.');
        return false;
      });
    }

    /**
     * Generates the JSON as we'll store it on Redis.
     */

  }, {
    key: '_toJSON',
    value: function _toJSON(eventData) {
      return (0, _stringify2.default)({
        m: this.meta,
        e: eventData
      });
    }

    /**
     * We are returning true because the go syncronizer push the impressions from redis.
     */

  }, {
    key: 'isEmpty',
    value: function isEmpty() {
      return true;
    }
  }]);
  return EventsCache;
}();

exports.default = EventsCache;
module.exports = exports.default;