"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _stringify = require("babel-runtime/core-js/json/stringify");

var _stringify2 = _interopRequireDefault(_stringify);

var _classCallCheck2 = require("babel-runtime/helpers/classCallCheck");

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require("babel-runtime/helpers/createClass");

var _createClass3 = _interopRequireDefault(_createClass2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
Copyright 2016 Split Software

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
**/

var ImpressionsCacheInRedis = function () {
  function ImpressionsCacheInRedis(keys, redis, meta) {
    (0, _classCallCheck3.default)(this, ImpressionsCacheInRedis);

    this.keys = keys;
    this.redis = redis;
    this.meta = meta;
  }

  (0, _createClass3.default)(ImpressionsCacheInRedis, [{
    key: "track",
    value: function track(impressions) {
      var _this = this;

      return this.redis.rpush(this.keys.buildImpressionsKey(), this.toJSON(impressions)).then(function (queuedCount) {
        // If this is the creation of the key on Redis, set the expiration for it in 1hr.
        if (queuedCount === 1) {
          _this.redis.expire(_this.keys.buildImpressionsKey(), 3600);
        }
      });
    }
  }, {
    key: "toJSON",
    value: function toJSON(impressions) {
      var _this2 = this;

      return impressions.map(function (impression) {
        var keyName = impression.keyName,
            bucketingKey = impression.bucketingKey,
            feature = impression.feature,
            treatment = impression.treatment,
            label = impression.label,
            time = impression.time,
            changeNumber = impression.changeNumber;


        return (0, _stringify2.default)({
          m: _this2.meta,
          i: {
            k: keyName,
            b: bucketingKey,
            f: feature,
            t: treatment,
            r: label,
            c: changeNumber,
            m: time
          }
        });
      });
    }

    /**
     * We are returning true because the go syncronizer push the impressions from redis.
     */

  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return true;
    }
  }]);
  return ImpressionsCacheInRedis;
}();

exports.default = ImpressionsCacheInRedis;
module.exports = exports.default;